<?php
if (!defined('ABSPATH'))
    exit;

/**
 * Created by PhpStorm.
 * Author: GPLSAVER
 * Date: 1/27/2016
 * Time: 4:07 PM
 */
class GPLS_Woo_RFQ_PLUS_Settings
{

    /**
     * Constructor for the settings.
     */

    /**
     * Bootstraps the class and hooks required actions & filters.
     *
     */
    public static function init()
    {
        add_filter('woocommerce_get_sections_settings_gpls_woo_rfq', array(__CLASS__, 'gpls_woo_rfq_plus_get_sections'), 100000, 1);

        add_filter('wc_settings_gpls_woo_rfq_settings', array(__CLASS__, 'gpls_woo_rfq_plus_get_settings'), 100000, 2);


        add_action('woocommerce_admin_field_gpls_woo_html_editor', array(__CLASS__, 'gpls_woo_rfq_plus_admin_field_html_editor'), 100000, 1);

        add_action('woocommerce_admin_field_gpls_woo_text_area', array(__CLASS__, 'gpls_woo_rfq_plus_admin_text_area_field'), 100000, 1);

        add_action('woocommerce_admin_field_gpls_woo_chkbox_list', array(__CLASS__, 'gpls_woo_rfq_plus_admin_chkbox_list_field'), 100000, 1);

        add_action('woocommerce_admin_field_1_chkbox_list_field', array(__CLASS__, 'gpls_woo_rfq_plus_admin_1_chkbox_list_field'), 100000, 1);
        add_action('woocommerce_admin_field_1a_chkbox_list_field', array(__CLASS__, 'gpls_woo_rfq_plus_admin_1a_chkbox_list_field'), 100000, 1);
        add_action('woocommerce_admin_field_1b_chkbox_list_field', array(__CLASS__, 'gpls_woo_rfq_plus_admin_1b_chkbox_list_field'), 100000, 1);
        add_action('woocommerce_admin_field_1c_chkbox_list_field', array(__CLASS__, 'gpls_woo_rfq_plus_admin_1c_chkbox_list_field'), 100000, 1);

        add_action('woocommerce_admin_field_gpls_woo_chkbox_roles', array(__CLASS__, 'gpls_woo_rfq_plus_admin_chkbox_roles'), 100000, 1);

      //  add_action('woocommerce_admin_field_gpls_woo_chkbox_prod_marketing_list', array(__CLASS__, 'gpls_woo_rfq_plus_admin_chkbox_prod_marketing_list'),
      // 100000, 1);

        add_action('woocommerce_admin_field_gpls_woo_chkbox_prod_marketing_content_list', array(__CLASS__, 'gpls_woo_chkbox_prod_marketing_content_list'), 100000, 1);

        if (!has_filter('woocommerce_admin_settings_sanitize_option', array(__CLASS__, 'gpls_woo_rfq_plus_admin_field_validator'), 100000, 3)) {

            add_filter('woocommerce_admin_settings_sanitize_option', array(__CLASS__, 'gpls_woo_rfq_plus_admin_field_validator'), 100000, 3);
        }

        add_filter('woocommerce_settings_tabs_array', array(__CLASS__, 'add_settings_tab'), 100000);

        add_action('woocommerce_admin_field_auction_gpls_woo_html_editor', array(__CLASS__, 'gpls_woo_rfq_plus_admin_field_html_editor'), 100000, 1);

        // add_action('woocommerce_admin_field_gpls_woo_prod_marketing_by_category', array(__CLASS__, 'gpls_woo_rfq_gpls_woo_prod_marketing_by_category'), 10, 1);
    }


    public static function add_settings_tab($settings_tabs)
    {
        $settings_tabs['settings_gpls_woo_rfq'] = 'RFQ-ToolKit';
        return $settings_tabs;
    }

    public static function gpls_woo_rfq_get_cats()
    {
        $orderby = 'name';
        $order = 'asc';
        $hide_empty = false;
        $cat_args = array(
            'orderby' => $orderby,
            'order' => $order,
            'hide_empty' => $hide_empty,
        );

        $cats = get_terms('product_cat', $cat_args);

        $option = array();

        array_push($option, '');

        foreach ($cats as $key => $pagg) {

            $label = $pagg->name;

            if (trim($label) == '') continue;
            array_push($option, wp_specialchars_decode($label));
        }

        return $option;
    }

    public static function gpls_woo_rfq_get_roles()
    {


        $orderby = 'name';
        $order = 'asc';
        $hide_empty = false;
        $cat_args = array(
            'orderby' => $orderby,
            'order' => $order,
            'hide_empty' => $hide_empty,
        );

        // $cats = get_terms('product_cat', $cat_args);


        global $wp_roles;

        $all_roles = $wp_roles->roles;
        $cats = apply_filters('editable_roles', $all_roles);

        $option = array();

        $first_option = '';

        $home = '';


        $option[$home] = $first_option;

        foreach ($cats as $key => $pagg) {

            $option[$key] = $key;
        }

        return $option;

    }

    public static function gpls_woo_rfq_plus_admin_field_validator($value, $option, $raw_value)
    {
        if ($option['type'] == 'gpls_woo_html_editor') {
            $value = $raw_value;
        }

        if ($option['id'] == 'settings_gpls_woo_rfq_plus_normal_checkout') {

            if (!isset($_POST['settings_gpls_woo_rfq_show_prices']) && !isset($_POST['settings_gpls_woo_rfq_show_prices_everywhere'])
                && isset($_POST['settings_gpls_woo_rfq_plus_normal_checkout'])) {

                add_action('admin_notices', woo_plus_admin_functions::gpls_woo_rfq_plus_error_notice("price_hidden_with_normal_gateways"));

                $value = 'no';
            }

        }


        if ($option['id'] == 'settings_gpls_woo_rfq_bulk_rfq_enable') {

            if ($value == 'no')
            {


                global $wpdb;


               // $wpdb->query("SET SESSION AUTOCOMMIT=OFF;");
               // $wpdb->query("BEGIN;");

                $update_products_sql = "delete from " . $wpdb->prefix . "postmeta where meta_key='_gpls_woo_rfq_rfq_enable'; ";

                $update_products = $wpdb->query($update_products_sql);
               // $wpdb->query("COMMIT;");
              //  $wpdb->query("SET SESSION AUTOCOMMIT=ON;");

            }


            if ($value == 'yes') {

                global $wpdb;

                $products = $wpdb->get_results(
                    "SELECT * FROM " . $wpdb->prefix . "posts where post_type in ('product', 'product_variation')
                     and post_status='publish' ", OBJECT);

                $query = "SELECT * FROM " . $wpdb->prefix . "posts where post_type in ('product', 'product_variation')
                     and post_status='publish' ";


                if ($products) {

                    //$update_products_sql="SET autocommit=0; BEGIN; ";
                    //$update_products_sql .="update ".$wpdb->prefix."postmeta set meta_value='yes' where post_id=".$product->ID." and meta_key='_gpls_woo_rfq_rfq_enable'; ";
                    //$update_products_sql .=" COMMIT; SET autocommit=1;";


                  //  $wpdb->query("SET SESSION AUTOCOMMIT=OFF;");
                 //   $wpdb->query("BEGIN;");

                    foreach ($products as $product) {

                        $update_products_sql = "insert into " . $wpdb->prefix . "postmeta (`post_id`,`meta_key`,`meta_value`)
                             VALUES('" . $product->ID . "','_gpls_woo_rfq_rfq_enable','yes'); ";


                        $update_products = $wpdb->query($update_products_sql);
                    }
                   // $wpdb->query("COMMIT;");
                   // $wpdb->query("SET SESSION AUTOCOMMIT=ON;");
                }


            }


            $value = "";
        }


        if ($option['id'] == 'settings_gpls_woo_rfq_customer_note_text_page') {


            if ($value == 'yes') {

                try {
                    global $wpdb;

                    $ID = $wpdb->get_var("SELECT ID FROM " . $wpdb->prefix . "posts where post_name='customer-respond' 
                                      and post_status <>'trash'");

                    if (is_null($ID)) {

                        $page = array();
                        $page['post_type'] = 'page';
                        $page['post_content'] = '[gpls_woo_rfq_get_customer_response]';
                        $page['post_parent'] = 0;
                        $page['post_status'] = 'publish';
                        $page['post_title'] = 'Customer Respond';
                        $page['post_author'] = 1;
                        $page['post_name'] = 'customer-respond';
                        $page['comment_status'] = 'closed';
                        $page['ping_status'] = 'closed';

                        $pageid = wp_insert_post($page, false);

                    }

                } catch (Exception $e) {
                    np_write_log($e, __FILE__, __LINE__);
                }


            }


        }


        if ($option['id'] == 'settings_gpls_woo_rfq_bulk_rfq_enable_in_cat'
           // && isset($_POST["cats_1_run"])
        ) {


            if (isset($_POST['cats_1'])) {
                $cats = (array)$_POST['cats_1'];
            } else {
                $cats = array();
            }
            $value = implode(',', $cats);


            /*if ($value != '') {


                global $wpdb;


                $wpdb->query("SET SESSION AUTOCOMMIT=OFF;");
                $wpdb->query("BEGIN;");

                $update_products_sql = "delete from " . $wpdb->prefix . "postmeta  where meta_key='_gpls_woo_rfq_rfq_enable'; ";

                $update_products = $wpdb->query($update_products_sql);
                $wpdb->query("COMMIT;");
                $wpdb->query("SET SESSION AUTOCOMMIT=ON;");

                foreach ($cats as $cat) {

                    $cat = esc_html($cat);

                    $products_cat_query = $wpdb->get_results(
                        "SELECT ID FROM  " . $wpdb->prefix . "posts as post 
INNER JOIN " . $wpdb->prefix . "term_relationships rs ON rs.object_id = post.ID 
WHERE  post_status='publish' and post_type in('product', 'product_variation') 
and rs.term_taxonomy_id  in (select term_taxonomy_id from " . $wpdb->prefix . "term_taxonomy 
where taxonomy='product_cat' and term_id in (select term_id from " . $wpdb->prefix . "terms where name='" . $cat . "')) ", OBJECT);

                    if ($products_cat_query) {


                        $wpdb->query("SET SESSION AUTOCOMMIT=OFF;");
                        $wpdb->query("BEGIN;");

                        foreach ($products_cat_query as $product) {

                            $update_products_sql = "insert into " . $wpdb->prefix . "postmeta (`post_id`,`meta_key`,`meta_value`)
                             VALUES('" . $product->ID . "','_gpls_woo_rfq_rfq_enable','yes'); ";

                            $update_products = $wpdb->query($update_products_sql);
                        }
                        $wpdb->query("COMMIT;");
                        $wpdb->query("SET SESSION AUTOCOMMIT=ON;");

                    }
                }
            }*/

            if ($value == '' && isset($_POST["cats_1_run"])) {

                global $wpdb;

                $wpdb->query("SET SESSION AUTOCOMMIT=OFF;");
                $wpdb->query("BEGIN;");

                $update_products_sql .= "update " . $wpdb->prefix . "postmeta set meta_value='no' where meta_key='_gpls_woo_rfq_rfq_enable'; ";

                $update_products = $wpdb->query($update_products_sql);
                $wpdb->query("COMMIT;");
                $wpdb->query("SET SESSION AUTOCOMMIT=ON;");

            }

        }


        if ($option['id'] == 'settings_gpls_woo_rfq_bulk_hide_add_to_cart_cat'
          //  && isset($_POST["cats_1a_run"])
        )
        {


            if (isset($_POST['cats_1a'])) {
                $cats = (array)$_POST['cats_1a'];
            } else {
                $cats = array();
            }
            $value = implode(',', $cats);

            if ($value == '' && isset($_POST["cats_1a_run"])) {
                global $wpdb;

             //   $wpdb->query("SET SESSION AUTOCOMMIT=OFF;");
            //    $wpdb->query("BEGIN;");

                $update_products_sql = "delete from " . $wpdb->prefix . "postmeta where meta_key='_gpls_woo_rfq_no_add_to_cart'; ";

                $update_products = $wpdb->query($update_products_sql);
              //  $wpdb->query("COMMIT;");
              //  $wpdb->query("SET SESSION AUTOCOMMIT=ON;");
            }

            /*if ($value != '') {

                foreach ($cats as $cat) {

                    $cat = esc_html($cat);

                    $products_cat_query = $wpdb->get_results(
                        "SELECT ID FROM  " . $wpdb->prefix . "posts as post 
INNER JOIN " . $wpdb->prefix . "term_relationships rs ON rs.object_id = post.ID 
WHERE  post_status='publish' and post_type in('product', 'product_variation') 
and rs.term_taxonomy_id  in (select term_taxonomy_id from " . $wpdb->prefix . "term_taxonomy 
where taxonomy='product_cat' and term_id in (select term_id from " . $wpdb->prefix . "terms where name='" . $cat . "')) ", OBJECT);

                    if ($products_cat_query) {

                        $wpdb->query("SET SESSION AUTOCOMMIT=OFF;");
                        $wpdb->query("BEGIN;");

                        foreach ($products_cat_query as $product) {

                            // update_post_meta($product->ID, "_gpls_woo_rfq_no_add_to_cart", 'yes');

                            $update_products_sql = "insert into " . $wpdb->prefix . "postmeta (`post_id`,`meta_key`,`meta_value`)
                             VALUES('" . $product->ID . "','_gpls_woo_rfq_no_add_to_cart','yes'); ";

                            $update_products = $wpdb->query($update_products_sql);
                        }
                        $wpdb->query("COMMIT;");
                        $wpdb->query("SET SESSION AUTOCOMMIT=ON;");
                    }
                }

            }*/
        }


        if ($option['id'] == 'settings_gpls_woo_rfq_bulk_hide_price_cat'
            //&& isset($_POST["cats_1b_run"])
        ) {


            if (isset($_POST['cats_1b'])) {
                $cats = (array)$_POST['cats_1b'];
            } else {
                $cats = array();
            }

            $value = implode(',', $cats);

            if ($value == '' && isset($_POST["cats_1b_run"])) {
                global $wpdb;

              //  $wpdb->query("SET SESSION AUTOCOMMIT=OFF;");
             //   $wpdb->query("BEGIN;");

                $update_products_sql = "delete from " . $wpdb->prefix . "postmeta  where meta_key='_gpls_woo_rfq_hide_price'; ";

                $update_products = $wpdb->query($update_products_sql);
               // $wpdb->query("COMMIT;");
               // $wpdb->query("SET SESSION AUTOCOMMIT=ON;");
            }

           /* if ($value != '') {

                foreach ($cats as $cat) {

                    $cat = esc_html($cat);

                    $products_cat_query = $wpdb->get_results(
                        "SELECT ID FROM  " . $wpdb->prefix . "posts as post
INNER JOIN " . $wpdb->prefix . "term_relationships rs ON rs.object_id = post.ID
WHERE  post_status='publish' and post_type in('product', 'product_variation')
and rs.term_taxonomy_id  in (select term_taxonomy_id from " . $wpdb->prefix . "term_taxonomy
where taxonomy='product_cat' and term_id in (select term_id from " . $wpdb->prefix . "terms where name='" . $cat . "')) ", OBJECT);

                    if ($products_cat_query) {

                        $wpdb->query("SET SESSION AUTOCOMMIT=OFF;");
                        $wpdb->query("BEGIN;");

                        foreach ($products_cat_query as $product) {

                            $update_products_sql = "insert into " . $wpdb->prefix . "postmeta (`post_id`,`meta_key`,`meta_value`)
                             VALUES('" . $product->ID . "','_gpls_woo_rfq_hide_price','yes'); ";

                            $update_products = $wpdb->query($update_products_sql);
                        }
                        $wpdb->query("COMMIT;");
                        $wpdb->query("SET SESSION AUTOCOMMIT=ON;");

                    }

                }

            }*/

        }


        if ($option['id'] == 'settings_gpls_woo_rfq_bulk_only_one_product_cat'
         //   && isset($_POST["cats_1c_run"])
        ) {


            if (isset($_POST['cats_1c'])) {
                $cats = (array)$_POST['cats_1c'];
            } else {
                $cats = array();
            }

            $value = implode(',', $cats);

            if ($value == ''  && isset($_POST["cats_1c_run"]) ) {
                global $wpdb;

               // $wpdb->query("SET SESSION AUTOCOMMIT=OFF;");
                //$wpdb->query("BEGIN;");

                $update_products_sql = "delete from " . $wpdb->prefix . "postmeta  where meta_key='_gpls_woo_individual_per_order'; ";

                $update_products = $wpdb->query($update_products_sql);

              //  $wpdb->query("COMMIT;");
              //  $wpdb->query("SET SESSION AUTOCOMMIT=ON;");
            }

           /* if ($value != '') {

                foreach ($cats as $cat) {

                    $cat = esc_html($cat);

                    $products_cat_query = $wpdb->get_results(
                        "SELECT ID FROM  " . $wpdb->prefix . "posts as post 
INNER JOIN " . $wpdb->prefix . "term_relationships rs ON rs.object_id = post.ID 
WHERE  post_status='publish' and post_type in('product', 'product_variation') 
and rs.term_taxonomy_id  in (select term_taxonomy_id from " . $wpdb->prefix . "term_taxonomy 
where taxonomy='product_cat' and term_id in (select term_id from " . $wpdb->prefix . "terms where name='" . $cat . "')) ", OBJECT);

                    if ($products_cat_query) {

                        $wpdb->query("SET SESSION AUTOCOMMIT=OFF;");
                        $wpdb->query("BEGIN;");

                        foreach ($products_cat_query as $product) {

                            $update_products_sql = "insert into " . $wpdb->prefix . "postmeta (`post_id`,`meta_key`,`meta_value`)
                             VALUES('" . $product->ID . "','_gpls_woo_individual_per_order','yes'); ";

                            $update_products = $wpdb->query($update_products_sql);

                        }
                        $wpdb->query("COMMIT;");
                        $wpdb->query("SET SESSION AUTOCOMMIT=ON;");

                    }

                }

            }*/

        }


       /* if ($option['id'] == 'settings_gpls_woo_rfq_cats_new_prods') {
            $value = '';
            if (isset($_POST['cats'])) {
                $cats = $_POST['cats'];
                $value = implode(',', $cats);
            }
        }*/


        if (isset($_POST['settings_gpls_woo_rfq_bulk_rfq_enable_product_messages'])) {



            if (isset($_POST['marketing_cats'])) {
                $cats = (array)$_POST['marketing_cats'];
            } else {
                $cats = array();
            }

            global $wpdb;

          //  $wpdb->query("SET SESSION AUTOCOMMIT=OFF;");
          //  $wpdb->query("BEGIN;");


            //if ($value == 'yes')
            {

                /*foreach ($cats as $cat) {

                    $cat = esc_html($cat);

                    $products_cat_query = $wpdb->get_results(
                        "SELECT ID FROM  " . $wpdb->prefix . "posts as post 
INNER JOIN " . $wpdb->prefix . "term_relationships rs ON rs.object_id = post.ID 
WHERE  post_status='publish' and post_type in('product', 'product_variation') 
and rs.term_taxonomy_id  in (select term_taxonomy_id from " . $wpdb->prefix . "term_taxonomy 
where taxonomy='product_cat' and term_id in (select term_id from " . $wpdb->prefix . "terms where name='" . $cat . "')) ", OBJECT);

                    if ($products_cat_query) {


                     //   $wpdb->query("SET SESSION AUTOCOMMIT=OFF;");
                    //    $wpdb->query("BEGIN;");

                        foreach ($products_cat_query as $product) {

                            $update_products_sql = "insert into " . $wpdb->prefix . "postmeta (`post_id`,`meta_key`,`meta_value`)
                             VALUES('" . $product->ID . "','_gpls_woo_rfq_plus_show_product_email_message','yes'); ";

                            $update_products = $wpdb->query($update_products_sql);
                        }
                     //   $wpdb->query("COMMIT;");
                     //   $wpdb->query("SET SESSION AUTOCOMMIT=ON;");

                    }
                }*/

            }
            // $value = '';
        }


        if ($option['id'] == 'settings_gpls_woo_rfq_cats_new_enable_product_messages') {
            $value = '';
            if (isset($_POST['marketing_cats'])) {
                $cats = $_POST['marketing_cats'];
                $value = implode(',', $cats);
            }
        }


        /*  if (isset($_POST['settings_gpls_woo_rfq_bulk_rfq_update_product_messages'])) {
             if (isset($_POST['marketing_content_cats'])) {
                 $cats = (array)$_POST['marketing_content_cats'];
             } else {
                 $cats = array();
             }

             global $wpdb;


            if ($value == 'yes')
             {

                 $settings_gpls_woo_prod_marketing_by_category_array = get_option('settings_gpls_woo_prod_marketing_by_category_array', array());

                 foreach ($cats as $cat) {

                     $cat = esc_html($cat);

                     $products_cat_query = $wpdb->get_results(
                         "SELECT ID FROM  " . $wpdb->prefix . "posts as post
 INNER JOIN " . $wpdb->prefix . "term_relationships rs ON rs.object_id = post.ID
 WHERE  post_status='publish' and post_type in('product', 'product_variation')
 and rs.term_taxonomy_id  in (select term_taxonomy_id from " . $wpdb->prefix . "term_taxonomy
 where taxonomy='product_cat' and term_id in (select term_id from " . $wpdb->prefix . "terms where name='" . $cat . "')) ", OBJECT);

                     if ($products_cat_query) {


                         $wpdb->query("SET SESSION AUTOCOMMIT=OFF;");
                         $wpdb->query("BEGIN;");

                         foreach ($products_cat_query as $product) {

                             $update_products_sql = "insert into " . $wpdb->prefix . "postmeta (`post_id`,`meta_key`,`meta_value`)
                              VALUES('" . $product->ID . "','_gpls_woo_rfq_plus_product_email_message','" . $_POST['settings_gpls_woo_rfq_customer_product_message_content'] . "'); ";

                             $update_products = $wpdb->query($update_products_sql);

                             $settings_gpls_woo_prod_marketing_by_category_array[$cat] = $_POST['settings_gpls_woo_rfq_customer_product_message_content'];
                         }
                         $wpdb->query("COMMIT;");
                         $wpdb->query("SET SESSION AUTOCOMMIT=ON;");
                     }

                 }

                 update_option('settings_gpls_woo_prod_marketing_by_category_array', $settings_gpls_woo_prod_marketing_by_category_array);


             }

            //  $value = '';

        }
        */


        if ($option['id'] == 'settings_gpls_woo_rfq_cats_new_update_product_messages') {
            $value = '';
            if (isset($_POST['marketing_content_cats']))
            {
                $cats = $_POST['marketing_content_cats'];
                $value = implode(',', $cats);
            }



            global $wpdb;

            if ($value == '' && isset($_POST['settings_gpls_woo_rfq_bulk_rfq_update_product_messages'])) {
                //  $wpdb->query("SET SESSION AUTOCOMMIT=OFF;");
                //  $wpdb->query("BEGIN;");

                $update_products_sql = "delete from " . $wpdb->prefix . "postmeta  where meta_key='_gpls_woo_rfq_plus_product_email_message'; ";

                $update_products = $wpdb->query($update_products_sql);



                $update_products_sql = "delete from " . $wpdb->prefix . "postmeta  where meta_key='_gpls_woo_rfq_plus_show_product_email_message'; ";
                $update_products = $wpdb->query($update_products_sql);


            }

        }


        if ($option['id'] == 'settings_gpls_woo_rfq_plus_visible_price_roles') {
            $value = '';
            if (isset($_POST['cats_roles'])) {
                $cats = $_POST['cats_roles'];
                $value = implode(',', $cats);
            }
        }


        if ($option['id'] == 'settings_gpls_woo_rfq_delay_quote_hours') {
            if (!is_numeric($value)) {

                $value = '';
            }
        }


        if ($option['id'] == 'settings_gpls_woo_prod_marketing_by_category') {

            $value = get_option('settings_gpls_woo_prod_marketing_by_category_array');
        }







        if ($option['id'] == 'settings_gpls_woo_rfq_bulk_rfq_enable_empty_price') {

            global $wpdb;

            $proceed=false;

           // if ($value == 'yes-blanks-only' || $value == 'no-blanks-only' || $value == 'yes-zero-or-blank' || $value == 'no-zero-or-blank')
            {
                $proceed=true;
            }

            if($proceed==true) {


                if ($value == 'yes-blanks-only' || $value == 'no-blanks-only') {
                    $meta_value = " (product_price.meta_value='' OR product_price.meta_value is null ) ";
                }

                if ($value == 'yes-zero-or-blank' || $value == 'no-zero-or-blank') {
                    $meta_value = " ( product_price.meta_value='' OR product_price.meta_value is null OR product_price.meta_value=0 ) ";
                }

                $products = $wpdb->get_results(
                    "SELECT distinct product.ID as ID,product.post_type as post_type FROM " . $wpdb->prefix . "posts as
                     product LEFT JOIN " . $wpdb->prefix . "postmeta as product_price ON product.ID = product_price.post_ID
                WHERE (product.post_type = 'product' OR product.post_type = 'product_variation')
               AND product_price.meta_key = '_price' and " . $meta_value, OBJECT);


                if ($products) {

                //    $wpdb->query("SET SESSION AUTOCOMMIT=ON;");
                //    $wpdb->query("BEGIN;");

                    foreach ($products as $product) {

                        $product_id = $product->ID;
                        $selected_product = wc_get_product($product_id);

                        if ($product->post_type != 'product') {
                            $product_id = $selected_product->get_parent_id();
                        }
                        $update_products_sql = "delete from " . $wpdb->prefix . "postmeta 
                                where meta_key='_gpls_woo_rfq_rfq_enable' AND post_id='" . $product_id . "'; ";
                        $update_products = $wpdb->query($update_products_sql);

                    }

                //    $wpdb->query("COMMIT;");
                 //   $wpdb->query("SET SESSION AUTOCOMMIT=ON;");

                }


                if ($products) {

                //    $wpdb->query("SET SESSION AUTOCOMMIT=OFF;");
                //    $wpdb->query("BEGIN;");
                    $wpdb->query("SET SESSION AUTOCOMMIT=ON;");
                    foreach ($products as $product) {

                        $product_id = $product->ID;
                        $selected_product = wc_get_product($product_id);

                        if ($product->post_type != 'product') {
                            $product_id = $selected_product->get_parent_id();
                        }

                        if ($value == 'yes-blanks-only' || $value == 'yes-zero-or-blank') {
                            $update_products_sql = "insert into " . $wpdb->prefix . "postmeta (`post_id`,`meta_key`,`meta_value`)
                             VALUES('" . $product_id . "','_gpls_woo_rfq_rfq_enable','yes'); ";
                        }

                        $update_products = $wpdb->query($update_products_sql);
                    }

               //     $wpdb->query("COMMIT;");
               //     $wpdb->query("SET SESSION AUTOCOMMIT=ON;");
                }
            }

            $value = "";

        }


        return $value;


    }

    public static function gpls_woo_rfq_plus_admin_chkbox_roles($value)
    {

        $option_value = get_option($value['id'], $value['default']);
        $cats = GPLS_Woo_RFQ_PLUS_Settings::gpls_woo_rfq_get_roles();

        ?>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo $value['id']; ?>"><?php echo esc_html($value['title']); ?></label><br/>
            </th>
            <td class="forminp forminp-<?php echo sanitize_title($value['type']) ?>">

                <?php
                $option_value_list = explode(',', $option_value);
                ?>
                <select class="rfqtkselectRoles chosen" multiple="true" style="width:400px;" name="cats_roles[]">
                    <option>Choose...</option>
                    <?php

                    foreach ($cats as $cat) {
                        if (($cat) == '') continue;

                        if (in_array($cat, $option_value_list)) {
                            echo "<option selected='selected' value='$cat'>$cat</option>";
                        } else {
                            echo "<option  value='$cat' >$cat</option>>";;
                        }

                    }
                    ?>

                </select>
                <script>jQuery(document).ready(function () {
                        jQuery(".rfqtkselectRoles").chosen({
                            allow_single_deselect: true
                        });
                    });</script>
                <br style="clear: both"/><br style="clear: both"/>
                <?php echo $value['desc']; ?>

            </td>
        </tr>
        <?php


    }

    public static function gpls_woo_rfq_plus_admin_chkbox_prod_marketing_list($value)
    {


        $option_value = get_option($value['id'], $value['default']);
        $cats = GPLS_Woo_RFQ_PLUS_Settings::gpls_woo_rfq_get_cats();

        ?>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo $value['id']; ?>"><?php echo esc_html($value['title']); ?></label><br/>
            </th>
            <td class="forminp forminp-<?php echo sanitize_title($value['type']) ?>">
                <?php
                $option_value_list = explode(',', $option_value);
                ?>
                <select class="rfqtkselectm1 chosen" multiple="true" style="width:400px;" name="marketing_cats[]">
                    <option>Choose...</option>

                    <?php

                    foreach ($cats as $cat) {
                        if (($cat) == '') continue;

                        if (in_array($cat, $option_value_list)) {
                            echo "<option selected='selected' value='$cat'>$cat</option>";
                        } else {
                            echo "<option  value='$cat' >$cat</option>>";;
                        }

                    }
                    ?>

                </select>
                <br/>Check this to apply the categories before saving<input type="checkbox"
                                                                            name="settings_gpls_woo_rfq_bulk_rfq_enable_product_messages"
                                                                            id="settings_gpls_woo_rfq_bulk_rfq_enable_product_messages">
                <script>jQuery(document).ready(function () {
                        jQuery(".rfqtkselectm1").chosen({
                            allow_single_deselect: true
                        });
                    });</script>
                <br style="clear: both"/><br style="clear: both"/>
                <?php echo $value['desc']; ?>


            </td>
        </tr>
        <?php


    }


    public static function gpls_woo_chkbox_prod_marketing_content_list($value)
    {


        $option_value = get_option($value['id'], $value['default']);
        $cats = GPLS_Woo_RFQ_PLUS_Settings::gpls_woo_rfq_get_cats();




        ?>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo $value['id']; ?>"><?php echo esc_html($value['title']); ?></label><br/>
            </th>
            <td class="forminp forminp-<?php echo sanitize_title($value['type']) ?>">

                <?php
                $option_value_list = explode(',', $option_value);
                ?>
                <select class="rfqtkselectm1 chosen" multiple="true" style="width:400px;"
                        name="marketing_content_cats[]">
                    <option>Choose...</option>
                    <?php

                    foreach ($cats as $cat) {
                        if (($cat) == '') continue;

                        if (in_array($cat, $option_value_list)) {
                            echo "<option selected='selected' value='$cat'>$cat</option>";
                        } else {
                            echo "<option  value='$cat' >$cat</option>>";;
                        }

                    }
                    ?>

                </select>
                <br /><?php echo __('Clear the category input box above, and check the checkbox below,<br/> to remove this option from all products. ','rfqtk'); ?>

                <input type="checkbox" name="settings_gpls_woo_rfq_bulk_rfq_update_product_messages" id="settings_gpls_woo_rfq_bulk_rfq_update_product_messages">
                <script>jQuery(document).ready(function () {
                        jQuery(".rfqtkselectm1").chosen({
                            allow_single_deselect: true
                        });
                    });</script>
                <br style="clear: both"/><br style="clear: both"/>
                <?php echo $value['desc']; ?>


            </td>
        </tr>
        <?php


    }

    public static function gpls_woo_rfq_plus_admin_chkbox_list_field($value)
    {


        $option_value = get_option($value['id'], $value['default']);
        $cats = GPLS_Woo_RFQ_PLUS_Settings::gpls_woo_rfq_get_cats();

        ?>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo $value['id']; ?>"><?php echo esc_html($value['title']); ?></label><br/>
            </th>
            <td class="forminp forminp-<?php echo sanitize_title($value['type']) ?>">

                <?php
                $option_value_list = explode(',', $option_value);
                ?>
                <select class="rfqtkselect0 chosen" multiple="true" style="width:400px;" name="cats[]">
                    <option>Choose...</option>
                    <?php

                    foreach ($cats as $cat) {
                        if (($cat) == '') continue;

                        if (in_array($cat, $option_value_list)) {
                            echo "<option selected='selected' value='$cat'>$cat</option>";
                        } else {
                            echo "<option  value='$cat' >$cat</option>>";;
                        }

                    }
                    ?>

                </select>
                <script>jQuery(document).ready(function () {
                        jQuery(".rfqtkselect0").chosen({
                            allow_single_deselect: true
                        });
                    });</script>
                <br style="clear: both"/><br style="clear: both"/>
                <?php echo $value['desc']; ?>
            </td>
        </tr>
        <?php


    }


    public static function gpls_woo_rfq_plus_admin_1_chkbox_list_field($value)
    {
        $option_value = get_option($value['id'], $value['default']);
        $cats_1 = GPLS_Woo_RFQ_PLUS_Settings::gpls_woo_rfq_get_cats();


        ?>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo $value['id']; ?>"><?php echo esc_html($value['title']); ?></label><br/>
            </th>
            <td class="rfqtkselect forminp forminp-<?php echo sanitize_title($value['type']) ?>">
                <?php
                $option_value_list = explode(',', $option_value);

                ?>
                <select class="rfqtkselect1 chosen" multiple="true" style="width:400px;" name="cats_1[]">
                    <option>Choose...</option>
                    <?php

                    foreach ($cats_1 as $cat) {
                        if (($cat) == '') continue;

                        if (in_array($cat, $option_value_list)) {
                            echo "<option selected='selected' value='$cat'>$cat</option>";
                        } else {
                            echo "<option  value='$cat' >$cat</option>>";;
                        }

                    }
                    ?>

                </select>
                <br /><?php echo __('Clear the category input box above, and check the checkbox below,<br/> to remove this option from all products. ','rfqtk'); ?>
                <input type="checkbox" name="cats_1_run" id="cats_1_run">
                <script>jQuery(document).ready(function () {
                        jQuery(".rfqtkselect1").chosen({
                            allow_single_deselect: true
                        });
                    });</script>
                <br style="clear: both"/><br style="clear: both"/>
                <?php echo $value['desc']; ?>
            </td>
        </tr>

        <?php


    }

    public static function gpls_woo_rfq_plus_admin_1a_chkbox_list_field($value)
    {


        $option_value = get_option($value['id'], $value['default']);
        $cats_1a = GPLS_Woo_RFQ_PLUS_Settings::gpls_woo_rfq_get_cats();

        ?>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo $value['id']; ?>"><?php echo esc_html($value['title']); ?></label><br/>
            </th>
            <td class="forminp forminp-<?php echo sanitize_title($value['type']) ?>">
                <?php
                $option_value_list = explode(',', $option_value);
                ?>
                <select class="rfqtkselect1a chosen" multiple="true" style="width:400px;" name="cats_1a[]">
                    <option>Choose...</option>
                    <?php

                    foreach ($cats_1a as $cat) {
                        if (($cat) == '') continue;

                        if (in_array($cat, $option_value_list)) {
                            echo "<option selected='selected' value='$cat'>$cat</option>";
                        } else {
                            echo "<option  value='$cat' >$cat</option>>";;
                        }

                    }
                    ?>

                </select>
                <br /><?php echo __('Clear the category input box above, and check the checkbox below,<br/> to remove this option from all products. ','rfqtk'); ?>
                <input type="checkbox" name="cats_1a_run" id="cats_1a_run">
                <script>jQuery(document).ready(function () {
                        jQuery(".rfqtkselect1a").chosen({
                            allow_single_deselect: true
                        });
                    });</script>
                <br style="clear: both"/><br style="clear: both"/>
                <?php echo $value['desc']; ?>
            </td>
        </tr>
        <?php


    }

    public static function gpls_woo_rfq_plus_admin_1b_chkbox_list_field($value)
    {


        $option_value = get_option($value['id'], $value['default']);
        $cats_1b = GPLS_Woo_RFQ_PLUS_Settings::gpls_woo_rfq_get_cats();

        ?>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo $value['id']; ?>"><?php echo esc_html($value['title']); ?></label><br/>
            </th>
            <td class="forminp forminp-<?php echo sanitize_title($value['type']) ?>">
                <?php
                $option_value_list = explode(',', $option_value);
                ?>
                <select class="rfqtkselect1b chosen" multiple="true" style="width:400px;" name="cats_1b[]">
                    <option>Choose...</option>
                    <?php

                    foreach ($cats_1b as $cat) {
                        if (($cat) == '') continue;

                        if (in_array($cat, $option_value_list)) {
                            echo "<option selected='selected' value='$cat'>$cat</option>";
                        } else {
                            echo "<option  value='$cat' >$cat</option>>";;
                        }

                    }
                    ?>

                </select>
                <br /><?php echo __('Clear the category input box above, and check the checkbox below,<br/> to remove this option from all products. ','rfqtk'); ?>

                <input type="checkbox" name="cats_1b_run" id="cats_1b_run">
                <script>jQuery(document).ready(function () {
                        jQuery(".rfqtkselect1b").chosen({
                            allow_single_deselect: true
                        });
                    });</script>
                <br style="clear: both"/><br style="clear: both"/>
                <?php echo $value['desc']; ?>
            </td>
        </tr>
        <?php


    }


    public static function gpls_woo_rfq_plus_admin_1c_chkbox_list_field($value)
    {


        $option_value = get_option($value['id'], $value['default']);
        $cats_1c = GPLS_Woo_RFQ_PLUS_Settings::gpls_woo_rfq_get_cats();

        ?>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo $value['id']; ?>"><?php echo esc_html($value['title']); ?></label><br/>
            </th>
            <td class="forminp forminp-<?php echo sanitize_title($value['type']) ?>">
                <?php
                $option_value_list = explode(',', $option_value);
                ?>
                <select class="rfqtkselect1c chosen" multiple="true" style="width:400px;" name="cats_1c[]">
                    <option>Choose...</option>
                    <?php

                    foreach ($cats_1c as $cat) {
                        if (($cat) == '') continue;

                        if (in_array($cat, $option_value_list)) {
                            echo "<option selected='selected' value='$cat'>$cat</option>";
                        } else {
                            echo "<option  value='$cat' >$cat</option>>";;
                        }

                    }
                    ?>

                </select>
                <br /><?php echo __('Clear the category input box above, and check the checkbox below,<br/> to remove this option from all products. ','rfqtk'); ?>

                <input type="checkbox" name="cats_1c_run" id="cats_1c_run">
                <script>jQuery(document).ready(function () {
                        jQuery(".rfqtkselect1c").chosen({
                            allow_single_deselect: true
                        });
                    });</script>
                <br style="clear: both"/><br style="clear: both"/>
                <?php echo $value['desc']; ?>
            </td>
        </tr>
        <?php


    }


    public static function gpls_woo_rfq_plus_admin_text_area_field($value)
    {


        $option_value = get_option($value['id'], $value['default']);

        ?>
        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo $value['id']; ?>"><?php echo esc_html($value['title']); ?></label><br/>
            </th>
            <td class="forminp forminp-<?php echo sanitize_title($value['type']) ?>">
                <textarea style="<?php echo $value['css']; ?>" name="<?php echo $value['id']; ?>"
                          id="<?php echo $value['id']; ?>"><?php echo esc_textarea($option_value); ?></textarea><br/>
                <?php echo $value['desc']; ?>
            </td>
        </tr>
        <?php
    }


    public static function gpls_woo_rfq_gpls_woo_prod_marketing_by_category($value)
    {

        $description = '<div >' . $value['desc'] . '</div><br /><div><br /></div>';
        $option_value = WC_Admin_Settings::get_option($value['id'], $value['default']);

        ?>

        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo esc_attr($value['id']); ?>"><?php echo esc_html($value['title']); ?></label>

            </th>
            <td class="forminp forminp-<?php echo sanitize_title($value['type']) ?>">
                <?php echo $description; ?>

                <?php

                foreach ($option_value as $cat => $html) {
                    echo '<h3>' . $cat . '</h3>';
                    echo '<div>' . $html . '</div>';
                }
                ?>

            </td>
        </tr>

        <?php


    }


    public static function gpls_woo_rfq_plus_admin_field_html_editor($value)
    {


        $description = '<div >' . $value['desc'] . '</div><br /><div><br /></div>';
        $option_value = WC_Admin_Settings::get_option($value['id'], $value['default']);
        ?>

        <tr valign="top">
            <th scope="row" class="titledesc">
                <label for="<?php echo esc_attr($value['id']); ?>"><?php echo esc_html($value['title']); ?></label>

            </th>
            <td class="forminp forminp-<?php echo sanitize_title($value['type']) ?>">
                <?php echo $description; ?>

                <?php

                $settings = array(
                    'tabindex' => 1,
                    'textarea_rows' => $value['textarea_rows'],
                    'textarea_name' => esc_attr($value['id']),
                );

                //wp_editor($option_value, $value['id'], $settings);
                wp_editor(html_entity_decode($option_value), $value['id'], $settings);

                ?>

            </td>
        </tr>
        <?php
    }

    public static function gpls_woo_rfq_plus_get_sections($sections)
    {

        return gpls_woo_get_sections_plus($sections);

    }


    public static function gpls_woo_rfq_plus_get_settings($settings, $section)
    {
        switch ($section) {


            case '' :
                //$settings =
                $settings =
                    array(
                        'general_section_title' => array(
                            'name' => __('RFQ-ToolKit General Options', 'rfqtk'),
                            'type' => 'title',
                            'desc' => __('RFQ-ToolKit general options ', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_general_section_title'
                        ),
                        'checkout_option' => array(
                            'name' => '1- ' . __('Checkout Option', 'rfqtk'),
                            'type' => 'select',
                            'options' => array(
                                'normal_checkout' => __('Normal Checkout', 'rfqtk'),
                                'rfq' => __('RFQ', 'rfqtk')),
                            'desc' => '<h4>' .
                                __('RFQ turns WooCommerce shopping cart into a request for quote.<br /> 
         In premium version there are additional options to buy or request the whole cart as a quote at WooCommerce checkout.<br />
          RFQ option provides very high compatibility with other third party plugins and products.<br />
           Normal option allows checking out normally or request a quote using a quote cart.', 'rfqtk') .
                                '</h4>' . __('Normal Checkout: If normal checkout, prices will be shown except for selected products<br />
 (managed in product setup-advanced tab) and <br />
 customer can only inquire about the products that you specify in product setup in the advanced tab.<br />
<br>RFQ Checkout: In RFQ mode the plugin is integrated with the WooCommerce cart and<br />
 the entire cart is submitted as a quote request.<br /> All the prices are hidden and at checkout the option is to submit a quote request.<br />', 'rfqtk') . '</h4>',
                            'default' => 'normal_checkout',
                            'id' => 'settings_gpls_woo_rfq_checkout_option'
                        ),

                        'settings_gpls_woo_rfq_show_prices' => array(
                            'name' => '2- ' . __('Always Show Product Prices With RFQ Checkout', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Applicable to RFQ checkout option only.<br /> Prices are shown for products but checkout is still a request for quote. Premium version show prices in the email and thank you page also.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_show_prices'
                        ),

                        'gpls_woo_rfq_hide_price_cart_checkout' => array(
                            'name' => '2A- ' . __('Hide prices in cart and checkout with RFQ Checkout.', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Applicable to RFQ checkout option only.<br /> Prices are not shown in cart or checkout.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'gpls_woo_rfq_hide_price_cart_checkout'
                        ),


                        'settings_gpls_woo_rfq_normal_checkout_show_prices' => array(
                            'name' => '3- ' . __('Show Prices With Normal Checkout', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Applicable to normal checkout option only.<br /> Prices are shown on the site but customer can inquire or checkout with selected products.< br />
                            This allows customers to checkout using the published prices or to request a personalized quote.  Premium version show prices in the email and thank you page also', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_normal_checkout_show_prices'
                        ),
                        'settings_gpls_woo_rfq_allow_out_of_stock' => array(
                            'name' => '3-0 ' . __('Allow quote items when they are out of stock', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('<br />.Allow quote items when they are out of stock', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_allow_out_of_stock'
                        ),
                        'rfq_cart_wordings_outofstock_text' => array(
                            'name' => '3-01- Normal & RFQ Checkout-' . __('sold-out Message', 'rfqtk'),
                            'type' => 'text',
                            'desc' => 'If not blank and,<br />
                                    "Allow quote items when they are out of stock" is selected,<br />
                                     this message will show if customer is viewing a sold-out quote item',
                            'default' => '',
                            'id' => 'rfq_cart_wordings_outofstock_text',
                            'css' => 'width:400px'
                        ),

                        'settings_gpls_woo_rfq_global_no_add_to_cart' => array(
                            'name' => '3A- ' . __('Normal Checkout: Hide Add To Cart. Show Only Add To Quote', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Applicable to normal checkout option only.<br />Hide the Add to cart button for all quote items. Even when prices are showing', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_global_no_add_to_cart'
                        ),


                        'settings_gpls_woo_rfq_hide_visitor_prices' => array(
                            'name' => '4- ' . __('Hide Prices from Visitors For Quote Request', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Hide Prices From Visitor. Visitors who are not logged in can only submit a quotes request. <br />.Enable guest checkout so the customers can submit requests as guest', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_hide_visitor_prices'
                        ),

                        'settings_gpls_woo_rfq_hide_visitor_add_to_quote' => array(
                            'name' => '4- 0 ' . __('Normal Checkout: Hide Add to Quote from Visitors in normal checkout', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Hide Add to Quote from Visitors in normal checkout: 
Visitors who are not logged in can not submit a quotes request. <br />.
', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_hide_visitor_add_to_quote'
                        ),

                        'settings_gpls_woo_rfq_plus_skip_zero_cart' => array(
                            'name' => '4-00 ' . __('RFQ Checkout - Skip quote request for zero dollar orders', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => "<br />" . __('If an order total is zero at checkout(including shipping and taxes), <br />
                              then don\'t create a quote request and treat it as a free giveaway instead of quote request.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_plus_skip_zero_cart',

                        ),

                        'rfq_cart_wordings_proceed_to_rfq_zero_cart' => array(
                            'name' => '4-01 ' . __('RFQ Checkout- Proceed To Submit Your Label if option 5I above is checked', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('RFQ Checkout- Proceed To Submit Your Label if option 4-00 above is checked', 'rfqtk'),
                            'default' => __('Place Order', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_proceed_to_rfq_zero_cart',
                            'css' => 'width:400px'
                        ),

                        'general_section_end33552' => array(
                            'type' => 'sectionend',
                            'id' => 'general_section_end33552'
                        ),


                        'general_section233553_title' => array(
                            'name' => '=======================================================',
                            'type' => 'title',

                            'id' => 'general_section233553_title'
                        ),

                        'general_section300_title' => array(
                            'name' => __('Enable role based price visibility and checkout options at checkout', 'rfqtk'),
                            'type' => 'title',

                            'id' => 'settings_gpls_woo_rfq_general_section3_title'
                        ),

                        'settings_gpls_woo_rfq_plus_role_based_visible' => array(
                            'name' => '4a- ' . __('RFQ Checkout: Enable role based price visibility and checkout options at checkout', 'rfqtk'),
                            'type' => 'select',
                            'options' => array(
                                'no' => '',
                                'purchase' => __('1: Selected roles can view prices, RFQ or purchase. Others can only request a quote', 'rfqtk'),
                                'others_purchase_only' => __('2: Selected roles can view prices, RFQ or purchase. Others can only purchase', 'rfqtk')),
                            'desc' => "<br /><br />" . __('option 1: Only selected roles can view prices.<br /> Also, only selected roles can purchase at checkout when using Option 5-buy now or request a quote.<br /> Other roles cannot view prices and can only request a quote at checkout.<br /><br />option 2:  Only selected roles can view prices.<br /> Also, only selected roles can purchase at checkout when using Option 5-buy now or request a quote.<br />Other roles can view prices and can only purchase at checkout.<br /><br />Roles do not affect Option 5C "Buy Or Request based on items in the cart"', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_plus_role_based_visible'
                        ),


                        'settings_gpls_woo_rfq_plus_visible_price_roles' => array(
                            'name' => '4b- ' . __('RFQ Checkout: Select roles that can view prices.', 'rfqtk'),
                            'type' => 'gpls_woo_chkbox_roles',
                            'desc' => '',
                            'default' => '',
                            'id' => 'settings_gpls_woo_rfq_plus_visible_price_roles',
                            'css' => 'width:600px;height:100px;vertical-align: top'
                        ),
                        'general_section300dd_end' => array(
                            'type' => 'sectionend',
                            'id' => 'general_section3dd_end'
                        ),


                        'general_section_end3432' => array(
                            'type' => 'sectionend',
                            'id' => 'general_section_end3432'
                        ),

                        'general_section23erf33_title' => array(
                            'name' => '=======================================================',
                            'type' => 'title',

                            'id' => 'general_section23erf33_title'
                        ),


                        'general_section3_title' => array(
                            'name' => __('Buy Or Request a Quote Section', 'rfqtk'),
                            'type' => 'title',
                            'desc' => __('Buy Or Request a Quote Section. This applies to RFQ mode only. You can present both the choice to purchase or request a quote.', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_general_section3_title'
                        ),

                        'settings_gpls_woo_rfq_plus_normal_checkout' => array(
                            'name' => '5- ' . __('Allow Other Payment Methods In RFQ Checkout Mode. Buy Or Request a Quote', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => "<br />" . __('Applicable to RFQ checkout option only.<br /> Allow customer to pay or submit a quote request at Checkout.<br /> Allows either "Checkout or Request quote" for the entire cart.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_plus_normal_checkout'
                        ),
                        'settings_gpls_woo_rfq_plus_normal_checkout_limit_message' => array(
                            'name' => '5A- ' . __('Message to Customer for Buy or Request a Quote at cart and checkout. Leave blank if no message)', 'rfqtk'),
                            'type' => 'text',
                            'desc' => "<br />" . __('Message to Customer for Buy or Request a Quote at cart and checkout', 'rfqtk'),
                            'default' => '',
                            'id' => 'settings_gpls_woo_rfq_plus_normal_checkout_limit_message',
                            'css' => 'width:600px;'
                        ),
                        'general_section3dd_end' => array(
                            'type' => 'sectionend',
                            'id' => 'general_section3dd_end'
                        ),

                        'general_section3sx_title' => array(
                            'name' => __('Buy Or Request a Quote based on minimum purchase', 'rfqtk'),
                            'type' => 'title',
                            'id' => 'general_section3sx_title'
                        ),

                        'settings_gpls_woo_rfq_plus_normal_checkout_limit' => array(
                            'name' => '5B- ' . __('Minimum purchase to allow Quote Request Option at Checkout(This works with option 5 above. Leave blank if no minimum)', 'rfqtk'),
                            'type' => 'number',
                            'desc' => "<br />" . __('Minimum purchase to allow Quote Request at checkout', 'rfqtk'),
                            'default' => '',
                            'id' => 'settings_gpls_woo_rfq_plus_normal_checkout_limit',
                            'css' => 'width:100px'
                        ),


                        'general_section3ddx_end' => array(
                            'type' => 'sectionend',
                            'id' => 'general_section3ddx_end'
                        ),

                        'general_section3sxx_title' => array(
                            'name' => __('Buy Or Request a Quote based on items in the cart', 'rfqtk'),
                            'type' => 'title',
                            'id' => 'general_section3sxx_title'
                        ),


                        'settings_gpls_woo_rfq_limit_to_rfq_only' => array(
                            'name' => '5C- ' . __('Option 5 must be active. Limit to quote request only if any of the products in the cart is marked as "RFQ-Enabled" in the product setup. Minimum limit above does not apply with this option. The whole cart is submitted as a quote request. If there are no RFQ enabled products, customer can purchase normally', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Applicable to RFQ checkout option only. 
                            If the cart contains a "quote item" (as setup in the product advance setup)<br /> 
                            then customer can only request a quote. <br />If this option is picked the minimum purchase does not apply.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_limit_to_rfq_only',
                        ),


                        'settings_gpls_woo_rfq_limit_to_rfq_only_message_quote' => array(
                            'name' => '5C1- ' . __('Message to customer for Quote Request based on items in the cart at cart and checkout. Leave blank if no message)', 'rfqtk'),
                            'type' => 'text',
                            'desc' => "<br />" . __('Message to customer for Quote Request based on items in the cart at cart and checkout', 'rfqtk'),
                            'default' => '',
                            'id' => 'settings_gpls_woo_rfq_limit_to_rfq_only_message_quote',
                            'css' => 'width:600px;'
                        ),
                        'settings_gpls_woo_rfq_limit_to_rfq_only_message_purchase' => array(
                            'name' => '5C2- ' . __('Message to customer for purchase based on items in the cart at cart and checkout. Leave blank if no message)', 'rfqtk'),
                            'type' => 'text',
                            'desc' => "<br />" . __('Message to customer for purchase based on items in the cart at cart and checkout', 'rfqtk'),
                            'default' => '',
                            'id' => 'settings_gpls_woo_rfq_limit_to_rfq_only_message_purchase',
                            'css' => 'width:600px;'
                        ),


                        'settings_gpls_woo_rfq_plus_normal_checkout_redirect' => array(
                            'name' => '5D- ' . __('Option 5 must be active. Redirect to checkout for quote request only', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Applicable to RFQ checkout option only. If the cart contains a "quote item" then redirect to checkout.
                             <br /> <b>If you select this option, Remove the "Enable AJAX add to cart buttons on archives" and <br />
                              "Redirect to the cart page after successful addition" options from 
                             <a href="/wp-admin/admin.php?page=wc-settings&tab=products"  target="_blank" >WooCommerce Products setting</a></b>', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_plus_normal_checkout_redirect',
                        ),
                        'settings_gpls_woo_rfq_plus_normal_checkout_redirect_purchase' => array(
                            'name' => '5D1- ' . __('Option 5 must be active. Redirect to checkout for purchase only', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Applicable to RFQ checkout option only. If the cart does not contains a "quote item" then redirect to checkout.
                             <br /> <b>If you select this option, Remove the "Enable AJAX add to cart buttons on archives"  and <br />
                              "Redirect to the cart page after successful addition" options from 
                             <a href="/wp-admin/admin.php?page=wc-settings&tab=products" target="_blank" >WooCommerce Products setting</a></b>', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_plus_normal_checkout_redirect_purchase',
                        ),


                        'settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices' => array(
                            'name' => '5E- ' . __('Hide prices for quote items in the option above', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Hide the prices for quote items. You can optionally hide prices for individual items in the product setup', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_limit_to_rfq_only_hide_prices',
                        ),


                        'settings_gplsrfqtk_limit_to_rfq_only_purchase_option' => array(
                            'name' => '5F- ' . __('Choose the default for option 5c if there are not quote items', 'rfqtk'),
                            'type' => 'select',
                            'options' => array(
                                'purchase_or_quote' => __('1: Purchase or quote', 'rfqtk'),
                                'purchase_only' => __('2: Purchase only', 'rfqtk')),
                            'default' => 'purchase_only',
                            'id' => 'settings_gplsrfqtk_limit_to_rfq_only_purchase_option'
                        ),



                        'settings_gpls_woo_rfq_limit_no_mixing_quote_with_purchase' => array(
                            'name' => '5G- ' . __("Don't allow mixing of quote and purchase items in the cart", 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __("Don't allow mixing quotes and purchases in the same cart. < br />
                            If a purchase is added to cart, only allow purchases till customer checks out with the purchase.< br />In the same way, if a quote is added to cart <br />
                            Then customer can only add quote items till customer checks out with the quote.", 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_limit_no_mixing_quote_with_purchase',
                        ),

                        'settings_gpls_woo_rfq_limit_no_mixing_quote_with_purchase_message' => array(
                            'name' => '5H- RFQ Checkout-' . __("Don't allow mixing of quote and purchase items in the cart message", 'rfqtk'),
                            'type' => 'textarea',
                            'desc' => 'If not blank, this notice will show if customer tries to mix purchase and quote items in the cart.<br /><br />',
                            'default' => __('Purchase items can only be in the cart with other purchase items. Please submit your current request first.', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_limit_no_mixing_quote_with_purchase_message',
                            'css' => 'width:600px;height:50px;vertical-align:top'
                        ),


                        'settings_gpls_woo_rfq_limit_to_rfq_only_no_shipping' => array(
                            'name' => '5i- Experimental RFQ Checkout- ' . __('Cart without an available shipping at checkout is a quote request', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('If there is no shipping method available at <b><u>checkout</u></b>, customer can submit the cart as a quote request', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_limit_to_rfq_only_no_shipping',
                        ),
                        'settings_gpls_woo_rfq_limit_to_rfq_only_no_shipping_message' => array(
                            'name' => '5i-A RFQ Checkout-' . __("Don't allow mixing of quote and purchase items in the cart message", 'rfqtk'),
                            'type' => 'textarea',
                            'desc' => 'If not blank, this notice will show instead of the standard "no shipping method available".<br /><br />',
                            'default' => __('Please submit your quote request and we will respond as soon as possible.', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_limit_to_rfq_only_no_shipping_message',
                            'css' => 'width:600px;height:50px;vertical-align:top'
                        ),

                        'general_section_end332' => array(
                            'type' => 'sectionend',
                            'id' => 'general_section_end332'
                        ),


                        'general_section3sxxX_title' => array(
                            'name' => __('Split the cart based on items in the cart', 'rfqtk'),
                            'type' => 'title',
                            'id' => 'general_section3sxxX_title'
                        ),


                        'settings_gpls_woo_rfq_5j' => array(
                            'name' => '5J- ' . __('Split Cart: Split the cart for two orders: One purchase and a quote request', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Applicable to RFQ checkout option only. <b>Option 1 should be RFQ. Options 2,5 and 5C must be active</b> <br /> 
                           If cart includes both purchase and quote items, create is split between two orders:<br /> One purchase and a quote request. Customer submits the order first and then the quote.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_5j',
                        ),

                        'settings_gpls_5j0_before_purchase_checkout_notice' => array(
                            'name' => '5J0- ' . __('Split cart: Instructions for the customer at cart before submitting the purchase. Leave blank if no message)', 'rfqtk'),
                            'type' => 'gpls_woo_html_editor',
                            'desc' => "<br />" . __('Instructions for the customer at cart before submitting the purchase', 'rfqtk'),
                            'default' => '<div class="woocommerce"><div class="woocommerce-info">' . __('Please complete your purchase first. After checkout you can submit your quote request.' . '</div></div>', 'rfqtk'),
                            'id' => 'settings_gpls_5j0_before_purchase_checkout_notice',
                            'class' => 'gpls_woo_plus_htm_editor_wide',
                            'css' => 'width:600px;'
                        ),
                        'settings_gpls_5j_before_purchase_checkout_notice' => array(
                            'name' => '5J1- ' . __('Split cart: Instructions for the customer at checkout before submitting the purchase. Leave blank if no message)', 'rfqtk'),
                            'type' => 'gpls_woo_html_editor',
                            'desc' => "<br />" . __('Instructions for the customer at checkout before submitting the purchase', 'rfqtk'),
                            'default' => '<div class="woocommerce"><div class="woocommerce-info">' . __('Please complete your purchase first. After checkout you can submit your quote request.' . '</div></div>', 'rfqtk'),
                            'id' => 'settings_gpls_5j_before_purchase_checkout_notice',
                            'class' => 'gpls_woo_plus_htm_editor_wide',
                            'css' => 'width:600px;'
                        ),

                        'settings_gpls_5j_after_purchase_thankyou_message' => array(
                            'name' => '5J3-' . __('Split cart: Instructions for the customer at thank you page before submitting the quote. Leave blank if no message', 'rfqtk'),
                            'type' => 'gpls_woo_html_editor',
                            'textarea_rows' => 5,
                            'default' => '<div class="woocommerce"><div class="woocommerce-info">' . __('Please submit your quote request.' . '</div></div>', 'rfqtk'),
                            'class' => 'gpls_woo_plus_htm_editor_wide',
                            'id' => 'settings_gpls_5j_after_purchase_thankyou_message',
                        ),


                        'settings_gpls_5j_after_purchase_notice' => array(
                            'name' => '5J4- ' . __('Split cart: cart notice for the customer at checkout and cart notice before submitting the quote. Leave blank if no message)', 'rfqtk'),
                            'type' => 'text',
                            'default' => __('Please submit your quote request.', 'rfqtk'),
                            'id' => 'settings_gpls_5j_after_purchase_notice',
                            'css' => 'width:600px;'
                        ),

                        'settings_gpls_woo_rfq_5j_redirect' => array(
                            'name' => '5J5- ' . __('Choose if you want to redirect to cart or checkout page.', 'rfqtk'),
                            'type' => 'select',
                            'options' => array(
                                '' => __(''),
                                'cart' => __('Cart', 'rfqtk'),
                                'checkout' => __('Checkout', 'rfqtk'),

                            ),
                            'default' => '',
                            'desc' => "<br />" . __('Split cart is submitted in two parts, purchase followed by quote request.<br />
                              You can choose to redirect the customer to cart or checkout page after purchase has been completed.', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_5j_redirect'
                        ),

                        'general_section_end332x' => array(
                            'type' => 'sectionend',
                            'id' => 'general_section_end332x'
                        ),


                        'general_section2333_title' => array(
                            'name' => '=======================================================',
                            'type' => 'title',

                            'id' => 'general_section2333_title'
                        ),


                        'general_section_end' => array(
                            'type' => 'sectionend',
                            'id' => 'settings_gpls_woo_rfq_general_section_end4'
                        ),

                        'general_section2_title' => array(
                            'name' => __('Bulk Action. If you have a very large number of products, consider running the following bulk steps seperately.', 'rfqtk'),
                            'type' => 'title',
                            'desc' => __('<a href="https://neahplugins.com/how-to-hide-a-category-in-woocommerce/" target="_blank"><b>Using fewer categories will improve performance for these bulk operations</a></b>', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_general_section245_title'
                        ),

                        'settings_gpls_woo_rfq_bulk_rfq_enable_in_cat' => array(
                            'name' => '1- ' . __('Bulk RFQ Enable/Disable Existing and New Products in a Category', 'rfqtk'),
                            'type' => '1_chkbox_list_field',
                            'desc' => __('Enable or remove RFQ status on existing and new products for selected categories 
                             <br />If categories are selected, only the selected categories will be quote items.', 'rfqtk'),
                            "default" => '',
                            'id' => 'settings_gpls_woo_rfq_bulk_rfq_enable_in_cat'
                        ),
                        'settings_gpls_woo_rfq_bulk_hide_add_to_cart_cat' => array(
                            'name' => '2- ' . __('Bulk Enable/Disable "Hide Add to Cart" for Existing and New Products in a Category', 'rfqtk'),
                            'type' => '1a_chkbox_list_field',
                            'desc' => __('Enable or remove "Hide Add to Cart" for existing and new Products for selected categories. 
                             <br />If categories are selected, "Add to cart" will be hidden only for the selected categories.', 'rfqtk'),
                            "default" => '',
                            'id' => 'settings_gpls_woo_rfq_bulk_hide_add_to_cart_cat'
                        ),


                        'settings_gpls_woo_rfq_bulk_hide_price_cat' => array(
                            'name' => '3- ' . __('Bulk Enable/Disable "Hide Price" for Existing and New Products in a Category', 'rfqtk'),
                            'type' => '1b_chkbox_list_field',
                            'desc' => __('Enable or remove "Hide Price" for existing and new Products for selected categories. 
                             <br />If categories are selected, "Add Price" will be hidden only for the selected categories.', 'rfqtk'),
                            "default" => '',
                            'id' => 'settings_gpls_woo_rfq_bulk_hide_price_cat'
                        ),
                        'settings_gpls_woo_rfq_bulk_only_one_product_cat' => array(
                            'name' => '4- ' . __('Bulk Enable/Disable "Only product in the order" for Existing and New Products in a Category', 'rfqtk'),
                            'type' => '1c_chkbox_list_field',
                            'desc' => __('Enable or remove "Only product in the order" for existing and new Products for selected categories. 
                             <br />If categories are selected, "Only product in the order" will be hidden only for the selected categories.', 'rfqtk'),
                            "default" => '',
                            'id' => 'settings_gpls_woo_rfq_bulk_only_one_product_cat'
                        ),
                        'settings_gpls_woo_rfq_bulk_only_one_message' => array(
                            'name' => '4-0- RFQ Checkout-' . __('Only product in the order message', 'rfqtk'),
                            'type' => 'textarea',
                            'desc' => 'If not blank, this notice will show if customer tries to add another product to the cart,<br />
                             while an exclusive product is in the cart. Product title will automatically be added to the <i><u>beginning</u></i> of message.<br /><br />',
                            'default' => __('can only be purchased individually without other products in the cart.', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_bulk_only_one_message',
                            'css' => 'width:600px;height:50px;vertical-align:top'
                        ),

                        'settings_gpls_woo_rfq_bulk_rfq_enable' => array(
                            'name' => '5- ' . __('Bulk Action for All Existing Products', 'rfqtk'),
                            'type' => 'select',
                            'options' => array(
                                '' => '',
                                'yes' => __('RFQ-Enable all existing products', 'rfqtk'),
                                'no' => __('Remove RFQ From all existing products', 'rfqtk'),
                            ),
                            'desc' => "<br />" . __('Enable or disable RFQ on all Existing products. <br />
                             This can take a long time depending on the number of your product. If you have a huge number of <br />>
                             products, please consider using categories above.', 'rfqtk'),
                            "default" => '',
                            'id' => 'settings_gpls_woo_rfq_bulk_rfq_enable'
                        ),


                        'settings_gpls_woo_rfq_rfq_enable_default' => array(
                            'name' => '6- ' . __('Normal Checkout. RFQ-Enable All New Products', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Enable RFQ on all new products', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_rfq_enable_default'
                        ),




                        'settings_gpls_woo_rfq_customer_confirmation_section_end33537' => array(
                            'type' => 'sectionend',
                            'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end33537'
                        ),


                        'general_sectionrecapcha_title' => array(
                            'name' => '=======================================================',
                            'type' => 'title',

                            'id' => 'general_sectionrecapcha_title'
                        ),
                        'general_sectionrecapcha_end' => array(
                            'type' => 'sectionend',
                            'id' => 'general_sectionrecapcha_end'
                        ),
                        'general_sectionrecapcha_title54789' => array(
                            'name' => 'Use Google reCAPTCHA For Quote Request',
                            'type' => 'title',
                            'id' => 'general_sectionrecapcha_title54789'
                        ),
                        'settings_gpls_woo_quote_use_captcha' => array(
                            'name' => '1- ' . __('Use Google reCAPTCHA For Quote Request', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Require Google reCAPTCHA for Quote Request. <a target="_blank" href="https://www.google.com/recaptcha/admin">Set up at Google</a>', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_quote_use_captcha'
                        ),
                        'settings_gpls_woo_quote_captcha_text' => array(
                            'name' => '2- ' . __('reCAPTCHA instructions', 'rfqtk'),
                            'type' => 'text',
                            'default' => '',
                            'desc' => __('reCAPTCHA instructions', 'rfqtk'),

                            'id' => 'settings_gpls_woo_quote_captcha_text'
                        ),
                        'settings_gpls_woo_quote_captcha_error' => array(
                            'name' => '3- ' . __('reCAPTCHA incomplete error prompt', 'rfqtk'),
                            'type' => 'text',
                            'default' => __('Please complete reCAPTCHA', 'rfqtk'),
                            'desc' => __('Text to prompt the user to complete the reCAPTCHA', 'rfqtk'),
                            'id' => 'settings_gpls_woo_quote_captcha_error'
                        ),


                        'settings_gpls_woo_rfq_file_sitekey' => array(
                            'name' => '4- ' . __('Google reCAPTCHA Site Key', 'rfqtk'),
                            'type' => 'text',
                            'desc' => '',
                            'default' => '',
                            'id' => 'settings_gpls_woo_rfq_file_sitekey',
                            'css' => 'width:600px'
                        ),

                        'settings_gpls_woo_rfq_file_secret_key' => array(
                            'name' => '5- ' . __('Google reCAPTCHA Secret Key', 'rfqtk'),
                            'type' => 'text',
                            'desc' => '',
                            'default' => '',
                            'id' => 'settings_gpls_woo_rfq_file_secret_key',
                            'css' => 'width:600px'
                        ),

                        'settings_gpls_woo_rfq_file_sitetheme' => array(
                            'name' => '6- ' . __('Google reCAPTCHA Theme', 'rfqtk'),
                            'type' => 'select',
                            'options' => array(
                                'Dark' => __('Dark', 'rfqtk'),
                                'light' => __('light', 'rfqtk'),
                            ),
                            'desc' => '',
                            'default' => 'light',
                            'id' => 'settings_gpls_woo_rfq_file_sitetheme',

                        ),

                        'general_sectionrecapcha_end8654745' => array(
                            'type' => 'sectionend',
                            'id' => 'general_sectionrecapcha_end8654745'
                        ),
                        'general_recapcha_end_title47145' => array(
                            'name' => '=======================================================',
                            'type' => 'title',

                            'id' => 'general_recapcha_end_title47145'
                        ),
                        'general_recapcha_end343434' => array(
                            'type' => 'sectionend',
                            'id' => 'general_recapcha_end343434'
                        ),


                        'general_section_title2264' => array(
                            'name' => __('Experimental Options', 'rfqtk'),
                            'type' => 'title',

                            'id' => 'general_section_title2264'
                        ),
                        'settings_gpls_plus_allow_anon_at_pay_order' => array(
                            'name' => '1- ' . __('Experimental. Allow visitors to pay for an order without having to log in first. ', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Experimental. It might not work with all payment gateways and third party plugins. Allow visitors to pay for an order without logging in.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_plus_allow_anon_at_pay_order'),


                        'settings_gpls_woo_rfq_address_at_pay_order' => array(
                            'name' => '2- ' . __('Experimental. Confirm billing / shipping address on pay order screen', 'rfqtk'),
                            'type' => 'select',
                            'options' => array(
                                'no' => 'No',
                                'yes' => __('Billing Address', 'rfqtk'),
                                'Billing_Shipping' => __('Billing & Shipping Address', 'rfqtk'),
                            ),
                            'desc' => __('Experimental. Confirm billing address on pay order screen(similar to regular checkout screen. The address collected, will be used for the order.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_address_at_pay_order'),
                        'settings_gpls_woo_rfq_update_user_profile_with_address' => array(
                            'name' => '3- ' . __('Experimental. Update user profile with addresses from payment screen above', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Experimental. Update user profile with address on pay order screen.
                             The address collected, will be used for this and future orders.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_update_user_profile_with_address'),


                        'rfq_cart_sc_section_support_for_wapf' => array(
                            'name' => '4- ' . __('Experimental. Normal Checkout only. Using WooCommerce Advanced Product Fields', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('<br />If you are using the WooCommerce Advanced Product Fields, then you should select this option.
                ', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_support_for_wapf',
                            'css' => 'width:600px;'
                        ),

                        'rfq_cart_sc_section_support_for_ultimate' => array(
                            'name' => '5- ' . __('Experimental. Normal Checkout only.Using WooCommerce Product Add-Ons Ultimate', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('<br />If you are using the add-ons ultimate, then you should select this option.
                ', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_support_for_ultimate',
                            'css' => 'width:600px;'
                        ),

                        'rfq_cart_sc_section_hide_prices_for_ultimate' => array(
                            'name' => '6- ' . __('Experimental. Normal Checkout only.Hide prices for WooCommerce Product Add-Ons Ultimate', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('<br />If you are using the add-ons ultimate and choosing to hide your prices, then you should select this option.
                 <br /> This only works if you hide <b>all</b> the prices.<br /> Additionally you will need to choose to show prices (2 or 3 above).<br /> Prices will not show but to the option has to be checked 
                 for the add-ons ultimate to capture the prices.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_hide_prices_for_ultimate',
                            'css' => 'width:600px;'
                        ),
                        'rfq_cart_sc_section_hide_add_to_cart_quickview' => array(
                            'name' => '7- ' . __('Experimental. Hide Add to Cart in QuickView for Quote Items', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('<br />If you are using a plugin 
for quickview of products in archives,<br /> then you can choose to hide the add to cart button in the quickview here. <br />Choosing this option will hide the add to cart 
for all quote items as well as when<br /> the option "Hide add to cart" is checked in the individual product setup in the advanced section.<br /> 
This works for WooCommerce QuickView, Quick View WooCommerce,Woo Quick View from the WordPress repository.
 ', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_hide_add_to_cart_quickview',
                            'css' => 'width:600px;'
                        ),
                        'rfq_cart_sc_section_hide_astra_quickview' => array(
                            'name' => '8- ' . __('Experimental. Astra Theme: Hide QuickView for Quote Items', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('<br />If you are using a the Astra theme, you can hide the QuickView for Quote items.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_hide_astra_quickview',
                            'css' => 'width:600px;'
                        ),



                        'settings_gpls_woo_rfq_customer_confirmation_section_endee33537' => array(
                            'type' => 'sectionend',
                            'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_endee33537'
                        ),

                        'general_section233we3ee_title' => array(
                            'name' => '=======================================================',
                            'type' => 'title',

                            'id' => 'general_section233we3ee_title'
                        ),
                        'settings_gpls_woo_rfq_general_section255_title' => array(
                            'name' => __('MISC Options', 'rfqtk'),
                            'type' => 'title',
                            'desc' => __('MISC options ', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_general_section255_title'
                        ),

                        'settings_gpls_woo_rfq_change_stock' => array(
                            'name' => '1- ' . __('Decrease stock with manual order-status chanage ', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => "<br />" . __('If you choose this option, stock quantity decreases when order status is manually changed to processing or completed', 'rfqtk') . "<br />" . __('processing to completed does not reduce again). Cancelling increases stock', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_change_stock'),

                        'settings_gpls_woo_rfq_hide_shipping' => array(
                            'name' => '2- ' . __('Shipping Totals: Hide Shipping in WooCommerce checkout', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Hide Shipping in WooCommerce Checkout', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_hide_shipping'
                        ),
                        'settings_gpls_woo_rfq_hide_shipping_prices' => array(
                            'name' => '3- RFQ Checkout-' . __('Shipping Totals: Hide Shipping prices in WooCommerce checkout for quote items', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Shipping Totals: Hide Shipping prices in WooCommerce checkout for quote items', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_hide_shipping_prices'
                        ),


                        'settings_gpls_woo_rfq_rfq_show_sales_badge' => array(
                            'name' => '4- ' . __('Show sales badge when prices are hidden', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Do you want the sales badge to show, if the item is on sale and prices are hidden?', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_rfq_show_sales_badge'
                        ),

                        'rfq_cart_hide_quote_extra_css' => array(
                            'name' => '4-01' .__(' Extra CSS to Hide Quote elements', 'rfqtk'),
                            'type' => 'textarea',
                            'desc' => 'You can add extra css for quote items in single page or in cart. For example: .your_class{visibility: hidden;}',
                            'id' => 'rfq_cart_hide_quote_extra_css',
                            'css' => 'width:600px;height:100px;vertical-align: top'
                        ),


                        'rfq_cart_sc_section_show_link_to_thankyou_page' => array(
                            'name' => '5- ' . __('Custom Thank you page URL for Quote Requests', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('You can redirect the users to a different URL after submitting their quore requests', 'rfqtk'),
                            'default' => '',
                            'id' => 'rfq_cart_sc_section_show_link_to_thankyou_page',
                            'css' => 'width:400px;'
                        ),


                        'general_section2_end' => array(
                            'type' => 'sectionend',
                            'id' => 'settings_gpls_woo_rfq_general245_section_end'
                        ),

                        'twitter_checkout_option2' => array(
                            'name' => '=======================================================',
                            'type' => 'title',
                            'desc' => __('<strong>If NP WooCommerce Quote Request is helpful to you, a <a  target="_blank" href="https://wordpress.org/support/plugin/woo-rfq-for-woocommerce/reviews/">rating</a> would be appreciated. Thank you in advance.<strong><br />Please visit us at <a rel="nofollow" target="_blank" href="http://www.neahplugins.com/">NeahPlugins</a>. You can <a rel="nofollow"  target="blank" href="mailto:contact@neahplugins.com" >contact</a> us for feedback or suggestions.</b>', 'rfqtk'),
                            'id' => 'twitter_checkout_option20',
                            'css' => 'width:600px; margin-top:50px'
                        ),
                        'general_section_end34055' => array(
                            'type' => 'sectionend',
                            'id' => 'general_section_end34550'
                        )


                    );
                break;
            case 'translations':

                $settings =

                    array(

                        'rfq_cart_wordings_section_title' => array(
                            'name' => __('Custom Labels', 'rfqtk'),
                            'type' => 'title',
                            'desc' => __('Manage labels and wordings', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_section_title'
                        ),
                        'rfq_cart_wordings_section_titlesectionend' => array(
                            'name' => __('Custom Labels', 'rfqtk'),
                            'type' => 'sectionend',
                            'desc' => __('Manage labels and wordings', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_section_titlesectionend'
                        ),
                        'rfq_cart_wordings_section_title_add_to_cart' => array(
                            'name' => __('Button texts for Add to Cart/Quote', 'rfqtk'),
                            'type' => 'title',
                            'desc' => __('Manage labels and wordings', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_section_title_add_to_cart'
                        ),
                        'rfq_cart_wordings_add_to_cart' => array(
                            'name' => '1- RFQ Checkout-' . __('Add To Cart Label', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Choose the text for "Add to Cart" - (Change to Add To Quote in RFQ Checkout)', 'rfqtk'),
                            'default' => __('Add to Cart', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_add_to_cart',
                            'css' => 'width:400px'
                        ),

                        'rfq_cart_wordings_in_cart' => array(
                            'name' => '2- RFQ Checkout-' . __('Add To Cart Again Label', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Choose the text for "Already in the Cart"- (Change to Add To Quote in RFQ Checkout) ', 'rfqtk'),
                            'default' => __('Add to Cart', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_in_cart',
                            'css' => 'width:400px'
                        ),

                        'rfq_cart_wordings_add_to_rfq' => array(
                            'name' => '3- Normal Checkout-' . __('Add To Quote Request Label', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Normal Checkout Only. Choose the text for "Request Quote"', 'rfqtk'),
                            'default' => __('Add To Quote', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_add_to_rfq',
                            'css' => 'width:400px'
                        ),

                        'rfq_cart_wordings_in_rfq' => array(
                            'name' => '4- Normal Checkout-' . __('Add To Quote Request Again Label', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Normal Checkout Only. Choose the text for "Already In Quote Request"', 'rfqtk'),
                            'default' => __('Add To Quote', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_in_rfq',
                            'css' => 'width:400px'
                        ),
                        'rfq_cart_wordings_section_title_add_to_cartsectionend' => array(
                            'name' => __('Custom Labels', 'rfqtk'),
                            'type' => 'sectionend',
                            'desc' => __('Manage labels and wordings', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_section_title_add_to_cartsectionend'
                        ),



                        'rfq_cart_wordings_section_title_proceed_to_checkout' => array(
                            'name' => __('Proceed to Checkout Button Text', 'rfqtk'),
                            'type' => 'title',
                            'desc' => __('Manage labels and wordings', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_section_title_proceed_to_checkout'
                        ),

                        'rfq_cart_wordings_proceed_to_rfq' => array(
                            'name' => '5- ' . __('RFQ Checkout- Proceed To checkout page label', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Choose for the "Proceed to ..." button in the cart page to go to checkout', 'rfqtk'),
                            'default' => __('Proceed To Submit Your Quote', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_proceed_to_rfq',
                            'css' => 'width:400px'
                        ),
                        'settings_gpls_woo_rfq_limit_to_rfq_only_cart_alt_label' => array(
                            'name' => '5A- RFQ Checkout ' . __('Choose alternate text for the "Proceed to ..." button in the cart page to go to checkout', 'rfqtk'),
                            'type' => 'text',
                            'default' => __('Proceed To Checkout', 'rfqtk'),
                            'desc' => __('This is used in combination with RFQ checkout advanced options in general tab.<br />
                             Please check this post: 
                                1: <a href="hhttps://neahplugins.com/woocommerce-quote-request-more-options/">Quote Request for WooCommerce: More Options</a> 2: <a href="https://neahplugins.com/woocommerce-buy-now-or-request-a-quote-2/">WooCommerce Buy Now or Request A Quote (based on the items in the cart)</a>
                                ', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_limit_to_rfq_only_cart_alt_label'
                        ),
                        'rfq_cart_wordings_section_title_proceed_checkout_sectionend' => array(
                            'name' => __('Custom Labels', 'rfqtk'),
                            'type' => 'sectionend',
                            'desc' => __('Manage labels and wordings', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_section_title_proceed_checkout_sectionend'
                        ),

                     /*   'settings_gpls_woo_rfq_purchase_only_proceed_to_checkout_cart_alt_label' => array(
                            'name' => '5B ' . __('this is GONE. this will be removed.', 'rfqtk'),
                            'type' => 'text',
                            'default' => 'Proceed to Checkout',
                            'desc' => __('' , 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_purchase_only_proceed_to_checkout_cart_alt_label'

                        ),*/

                        'rfq_cart_wordings_section_checkout_title_proceed' => array(
                            'name' => __('Checkout Page. Submit Your Quote Button Text', 'rfqtk'),
                            'type' => 'title',
                            'desc' => __('Manage labels and wordings', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_section_checkout_title_proceed'
                        ),
                        'rfq_cart_wordings_submit_your_rfq_text' => array(
                            'name' => '6- ' . __('Normal & RFQ Checkout - Submit Your Quote Label', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Normal & RFQ Checkout- Choose the text for "Submit Your Order/Request in the checkout page"', 'rfqtk'),
                            'default' => __('Submit Your Quote', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_submit_your_rfq_text',
                            'css' => 'width:400px'
                        ),

                        'settings_gpls_woo_rfq_limit_to_rfq_only_checkout_alt_label' => array(
                            'name' => '7- ' . __('RFQ Checkout- Choose alternate text for the "Submit your Order/Request" button in the checkout page', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Works with option 5 & 5C above. Choose alernate text for the "Submit your ..." button in the checkout page if there are quote items in the cart.<br />
                                Or if the user is in the selected roles when you are using roles. Also works if the selected payment method is quote request', 'rfqtk'),
                            'default' => '',
                            'id' => 'settings_gpls_woo_rfq_limit_to_rfq_only_checkout_alt_label'
                        ),
                        'rfq_cart_wordings_section_title_proceedsectionend' => array(
                            'name' => __('Custom Labels', 'rfqtk'),
                            'type' => 'sectionend',
                            'desc' => __('Manage labels and wordings', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_section_title_proceedsectionend'
                        ),

                        'rfq_cart_wordings_section_Misc_title_proceed' => array(
                            'name' => __('Misc', 'rfqtk'),
                            'type' => 'title',
                            'desc' => __('Manage labels and wordings', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_section_Misc_title_proceed'
                        ),

                        'rfq_cart_wordings_view_rfq_cart' => array(
                            'name' => '8- Normal & RFQ Checkout- ' . __('VIEW LIST', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Choose the text for "View Your Quote Cart"', 'rfqtk'),
                            'default' => __('View List', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_view_rfq_cart',
                            'css' => 'width:400px'
                        ),

                        'rfq_cart_wordings_rfq_cart_is_empty' => array(
                            'name' => '9- Normal Checkout- ' . __('Quote Request List Is Empty Label', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Choose the text for "You Quote cart is empty and was not submitted"', 'rfqtk'),
                            'default' => __('You quote request list is empty and was not submitted', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_rfq_cart_is_empty',
                            'css' => 'width:400px'
                        ),
                        'rfq_cart_wordings_return_to_shop' => array(
                            'name' => '10- Normal Checkout- ' . __('Return To Shop In Quote Request Page', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Choose the text for "Return To Shop In Quote Request Page"', 'rfqtk'),
                            'default' => __('Return To Shop', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_return_to_shop',
                            'css' => 'width:400px'
                        ),
                        'rfq_cart_wordings_product_was_added_to_quote_request' => array(
                            'name' => '11- Normal & RFQ Checkout- ' . __('Product Was Added To The Quote Request', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Choose the text for "Added to Quote List"', 'rfqtk'),
                            'default' => __('Product was successfully added to quote request.', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_product_was_added_to_quote_request',
                            'css' => 'width:400px'
                        ),
                        'gpls_woo_rfq_quote_submit_confirm_message' => array(
                            'name' => '12- Normal & RFQ Checkout- ' . __('Your Request Has Been Submitted', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Your quote request has been successfully submitted!', 'rfqtk'),
                            'default' => __('Your request has been successfully submitted!', 'rfqtk'),
                            'id' => 'gpls_woo_rfq_quote_submit_confirm_message',
                            'css' => 'width:400px'
                        ),
                        'rfq_cart_wordings_quote_request_currently_empty' => array(
                            'name' => '13- Normal Checkout- ' . __('Your Quote Request List Is Currently Empty', 'rfqtk'),
                            'type' => 'text',
                            'desc' => '',
                            'default' => __('Your Quote Request List is Currently Empty.', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_quote_request_currently_empty',
                            'css' => 'width:400px'
                        ),
                        'rfq_cart_wordings_gpls_woo_rfq_update_rfq_cart_button' => array(
                            'name' => '14- Normal Checkout-' . __('Update Quote Request', 'rfqtk'),
                            'type' => 'text',
                            'desc' => 'Button Text to update Quest Request List in Quote Request Page',
                            'default' => __('Update Quote Request', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_gpls_woo_rfq_update_rfq_cart_button',
                            'css' => 'width:400px'
                        ),
                        'settings_gpls_woo_rfq_customer_info_label' => array(
                            'name' => '15- Normal Checkout-' . __('Customer Information', 'rfqtk'),
                            'type' => 'text',
                            'desc' => 'Section title for customer information in the quote request page',
                            'default' => __('Customer Information', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_customer_info_label',
                            'css' => 'width:400px'
                        ),
                        'settings_gpls_woo_rfq_read_more' => array(
                            'name' => '16-  Normal & RFQ Checkout-' . __('Read more', 'rfqtk'),
                            'type' => 'text',
                            'desc' => 'label for products with options or no prices',
                            'default' => __('Read more', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_read_more',
                            'css' => 'width:400px'
                        ),
                        'settings_gpls_woo_rfq_Select_Options' => array(
                            'name' => '17-  Normal & RFQ Checkout-' . __('Select Options', 'rfqtk'),
                            'type' => 'text',
                            'desc' => 'label for products with options or no prices',
                            'default' => __('Select options', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_Select_Options',
                            'css' => 'width:400px'
                        ),


                    )


                    + array('settings_gpls_woo_rfq_quote_request_label' =>
                        array(
                            'name' => __('17- Normal or RFQ Checkout-Quote Requests Status Label In Orders Admin Page', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Choose the text for "Quote Requests" for admin orders screen', 'rfqtk'),
                            'default' => __('Quote Request', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_quote_request_label',
                            'css' => 'width:400px'
                        ))


                    + array('settings_gpls_woo_rfq_quote_sent_label' =>
                        array(
                            'name' => __('18- Normal or RFQ Checkout-Quotes Sent Status Label In Orders Admin Page', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Choose the text for "Quotes Sent" for admin orders screen', 'rfqtk'),
                            'default' => __('Quote Sent', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_quote_sent_label',
                            'css' => 'width:400px'
                        ))

                    + array('settings_gpls_woo_rfq_customer_accepted_offer_label' =>
                        array(
                            'name' => __('19- Normal or RFQ Checkout- Text showing "Customer accepted offer of"', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Choose the text for "Quotes Sent" for admin orders screen', 'rfqtk'),
                            'default' => __('Customer accepted offer of', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_customer_accepted_offer_label',
                            'css' => 'width:400px'
                        ))


                    + array('general_section222sd_end' =>
                        array(

                            'type' => 'sectionend',
                            'desc' => __('Choose the text for "View Quote Cart" button in the quote cart widget', 'rfqtk'),

                            'id' => 'general_section222sd_end',

                        ))


                    + array('general_section23s3we3ee_title' =>
                        array(
                            'name' => '=======================================================',

                            'type' => 'title',
                            'desc' => '<h2>' . __('Quote Cart widget', 'rfqtk') . '</h2>',

                            'id' => 'general_section23s3we3ee_title',

                        ))
                    + array('rfq_cart_wordings_view_rfq_cart_widget' =>
                        array(
                            'name' => '1- Normal Checkout- ' . __('"View Quote Cart" button', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Choose the text for "View Quote Cart" button in the quote cart widget', 'rfqtk'),
                            'default' => __('View', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_view_rfq_cart_widget',
                            'css' => 'width:100px'
                        ))


                    + array('rfq_cart_wordings_view_rfq_cart_widget_title' =>
                        array(
                            'name' => '2- Normal Checkout- ' . __('View Your Quote List', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Choose the text for "View Your Quote List" description for the quote cart widget (on mouse over).', 'rfqtk'),
                            'default' => __('View Your Quote List', 'rfqtk'),
                            'id' => 'rfq_cart_wordings_view_rfq_cart_widget_title',
                            'css' => 'width:200px'
                        ))
                    + array('general_section2700_end' =>
                        array(

                            'type' => 'sectionend',
                            'desc' => '',

                            'id' => 'general_section2700_end',

                        ));

                // array_slice($settings, count($settings) - 2, count($settings) - 1, true);


                break;

            case 'rfq_page':
                $settings = array_slice($settings, 0, count($settings) - 1, true)

                    + array(


                        'rfq_cart_sc_section_rfq_page_create_accounts' => array(
                            'name' => __('Allow Account Creation', 'rfqtk'),
                            'type' => 'select',
                            'options' => array(
                                'yes' => __('Allow customers to choose', 'rfqtk'),
                                'always' => __('Always create an account. Hide the password field', 'rfqtk'),
                                'always_pwd' => __('Always create an account. Show the password field and required', 'rfqtk'),
                                'no' => __('Never create an account', 'rfqtk')),
                            'desc' => __('Allow visitors to create an account.', 'rfqtk'),
                            'default' => 'yes',
                            'id' => 'rfq_cart_sc_section_rfq_page_create_accounts',
                            'css' => 'width:100%;'
                        ),

                        'rfq_cart_sc_section_page_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_section_page_title_end'
                        ),


                        'rfq_cart_sc_visitor_section_title' => array(
                            'name' => '',
                            'type' => 'title',
                            'desc' => __('<h1>Hide or make the following fields required for visitors.</h1>', 'rfqtk'),
                            'id' => 'rfq_cart_sc_visitor_section_title',
                            'css' => 'width:600px'
                        ),

                        'rfq_cart_sc_section_rfq_page_phone_hide' => array(
                            'name' => '1- ' . __('Hide Phone', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_phone_hide',
                            'css' => 'width:400px;'
                        ),

                        'rfq_cart_sc_section_rfq_page_phone_required' => array(
                            'name' => '1A- ' . __('Phone Required', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_phone_required',
                            'css' => 'width:400px;'
                        ),

                        'rfq_cart_sc_section_rfq_page_company_hide' => array(
                            'name' => '2- ' . __('Hide Company', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_company_hide',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_company_required' => array(
                            'name' => '2A- ' . __('Company Required', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_company_required',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_country_hide' => array(
                            'name' => '3- ' . __('Hide Country', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_country_hide',
                            'css' => 'width:400px;'
                        ),

                        'rfq_cart_sc_section_rfq_page_country_required' => array(
                            'name' => '3A- ' . __('Country Required', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_country_required',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_state_hide' => array(
                            'name' => '4- ' . __('Hide State', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_state_hide',
                            'css' => 'width:400px;'
                        ),

                        'rfq_cart_sc_section_rfq_page_state_required' => array(
                            'name' => '4A- ' . __('State Required', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_state_required',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_address_hide' => array(
                            'name' => '5- ' . __('Hide Address', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_address_hide',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_address_required' => array(
                            'name' => '5A- ' . __('Address Required', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_address_required',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_city_hide' => array(
                            'name' => '6- ' . __('Hide City', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_city_hide',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_city_required' => array(
                            'name' => '6A- ' . __('City Required', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_city_required',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_zip_hide' => array(
                            'name' => '7- ' . __('Hide Zip', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_zip_hide',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_zip_required' => array(
                            'name' => '7A- ' . __('Zip Required', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_zip_required',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_comment_hide' => array(
                            'name' => '8- ' . __('Hide Comment', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_comment_hide',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_comment_required' => array(
                            'name' => '8A- ' . __('Comment Required', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_comment_required',
                            'css' => 'width:400px;'
                        ),

                        'rfq_cart_sc_section_page_fields_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_section_page_title_end'
                        ),
                        'rfq_cart_sc_visitor_section_title234' => array(
                            'name' => '',
                            'type' => 'title',
                            'desc' => __('<h1>Style The quote request page</h1>.', 'rfqtk'),
                            'id' => 'rfq_cart_sc_visitor_section_title',
                            'css' => 'width:600px'
                        ),

                        'rfq_cart_sc_section_rfq_page_apply_style' => array(
                            'name' => __('Enable custom styling', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Enable/Disable styling.<br /> It applies or removes the following custom styling for the page including buttons', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_apply_style',
                            'css' => 'width:400px;'
                        ),
                        'gpls_woo_rfq_request_page_background' => array(
                            'name' => __('Main Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Main Background Color for the cart and customer info.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'gpls_woo_rfq_request_page_background',
                        ),

                        'rfq_cart_sc_section_page_title_end234' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_section_page_title_end'
                        ),

                        'rfq_cart_sc_page_cart_section_title' => array(
                            'name' => __('Customize Quote Cart', 'rfqtk'),
                            'type' => 'title',
                            'desc' => '',
                            'id' => 'rfq_cart_sc_page_cart_section_title',
                            'css' => 'width:600px'
                        ),


                        'rfq_cart_sc_section_rfq_page_update_cart_button_background' => array(
                            'name' => '1- ' . __('Update Request List Button Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Background color of update list button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_update_cart_button_background',
                        ),

                        'rfq_cart_sc_section_rfq_page_update_cart_button_color' => array(
                            'name' => '2- ' . __('Update Request List Button Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Font color of update list button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_update_cart_button_color',
                        ),
                        'rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background' => array(
                            'name' => '3- ' . __('Update Request List Button MouseOver Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Background color of update list button when you move the mouse over it.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background',
                        ),
                        'rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color' => array(
                            'name' => '4-' . __('Update Request List Button MouseOver Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Font color of update list button when you move the mouse over it.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color',

                        ),


                        'rfq_cart_sc_section_rfq_page_cart_background' => array(
                            'name' => '5- ' . __('Cart Column Header Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Column header color.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_background',
                        ),

                        'rfq_cart_sc_section_rfq_page_cart_header_background' => array(
                            'name' => '6- ' . __('Cart Row Header Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Background color for the Cart Row.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_header_background',
                        ),

                        'rfq_cart_sc_section_rfq_page_cart_header_color' => array(
                            'name' => '7- ' . __('Cart Row Header Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Cart Row Header Font Color', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_header_color',
                        ),

                        'rfq_cart_sc_section_rfq_page_cart_row_background' => array(
                            'name' => '8- ' . __('Cart Row Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Cart Row Background Color', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_row_background',
                        ),
                        'rfq_cart_sc_section_rfq_page_cart_font_color' => array(
                            'name' => '9- ' . __('Cart Row Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Cart Row Font Color.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_font_color',
                        ),
                        'rfq_cart_sc_section_rfq_page_cart_link_color' => array(
                            'name' => '10- ' . __('Cart Row Link Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Cart Row Link Color', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_link_color',
                        ),
                        'rfq_cart_sc_section_rfq_page_cart_image_size' => array(
                            'name' => '11- ' . __('Product Image Maximum Width', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Product image maximum width size in px,em or %, e.g. 4em , 800px or 80%', 'rfqtk'),
                            'default' => '',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_image_size',
                        ),

                        'rfq_cart_sc_page_cart_section_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_page_cart_section_title_end'
                        ),


                        'rfq_cart_sc_page_cust_info_title' => array(
                            'name' => __('Customize Customer Info', 'rfqtk'),
                            'type' => 'title',
                            'desc' => '',
                            'id' => 'rfq_cart_sc_page_cust_info_title',
                            'css' => 'width:600px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_submit_quote_button_background' => array(
                            'name' => '1- ' . __('Submit Quote Button Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Background color of update list button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_submit_quote_button_background',
                        ),

                        'rfq_cart_sc_section_rfq_page_submit_quote_button_color' => array(
                            'name' => '2- ' . __('Submit Quote Button Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Font color of update list button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_submit_quote_button_color',
                        ),
                        'rfq_cart_sc_section_rfq_page_submit_quote_button_mouse_over_background' => array(
                            'name' => '3- ' . __('Submit Quote Button MouseOver Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Background color of submit quote button when you move the mouse over it.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_submit_quote_button_mouse_over_background',
                        ),
                        'rfq_cart_sc_section_rfq_page_submit_quote_button_mouse_over_color' => array(
                            'name' => '4- ' . __('Submit Quote Button MouseOver Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Font color of submit quote button when you move the mouse over it.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_submit_quote_button_mouse_over_color',
                        ),


                        'rfq_cart_sc_section_rfq_cust_info_background' => array(
                            'name' => '5- ' . __('Customer Info Section Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer info background color for the whole section.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_cust_info_background',
                        ),

                        'rfq_cart_sc_section_rfq_cust_info_header_background' => array(
                            'name' => '6- ' . __('Customer Info Row Header Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer Info Row Header Background Color.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_cust_info_header_background',
                        ),

                        'rfq_cart_sc_section_rfq_cust_info_header_color' => array(
                            'name' => '7- ' . __('Customer Info Row Header Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer Info Row Header Font Color', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_cust_info_header_color',
                        ),

                        'rfq_cart_sc_section_rfq_cust_info_row_background' => array(
                            'name' => '8- ' . __('Customer Info Row Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer Info Row Background Color', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_cust_info_row_background',
                        ),
                        'rfq_cart_sc_section_rfq_cust_info_font_color' => array(
                            'name' => '9- ' . __('Customer Info Row Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer Info Row Font Color.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_cust_info_font_color',
                        ),

                        'rfq_cart_sc_section_rfq_woo_rfq_customer_info_header_color' => array(
                            'name' => '10- ' . __('Customer Info Section Title Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer Info Section Title Color.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_woo_rfq_customer_info_header_color',
                        ),
                        'rfq_cart_sc_section_rfq_woo_rfq_customer_info_input_background' => array(
                            'name' => '11- ' . __('Customer Info Input Field Background', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer Info Section Title Color.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_woo_rfq_customer_info_input_background',
                        ),

//
                        'rfq_cart_sc_section_rfq_woo_rfq_customer_info_border_color' => array(
                            'name' => '12- ' . __('Customer Info Border Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer info border color.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_woo_rfq_customer_info_border_color',
                        ),

                        'rfq_cart_sc_section_rfq_page_cart_border_size' => array(
                            'name' => '13- ' . __('Customer Info Border Width', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer border style size in px or em, e.g. 0.01em or 2px', 'rfqtk'),
                            'default' => '0px',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_border_size',
                        ),

                        'rfq_cart_sc_section_rfq_page_cart_border_style' => array(
                            'name' => '14- ' . __('Customer Info Border Style', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Customer border style, e.g. solid dashed', 'rfqtk'),
                            'default' => 'none',
                            'id' => 'rfq_cart_sc_section_rfq_page_cart_border_style',
                        ),

                        'rfq_cart_sc_page_cust_info_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_page_cust_info_title_end'
                        ),

                        'rfq_cart_sc_html_desc_section_title' => array(
                            'name' => '',
                            'type' => 'title',
                            'desc' => __('<h1>Create Custom Content</h1>', 'rfqtk'),
                            'id' => 'rfq_cart_sc_html_desc_section_title',
                            'css' => 'width:600px'
                        ),
                        'settings_gpls_woo_rfq_enabled_page_desc_top' => array(
                            'name' => '1- ' . __('Enable In Request for Quote Page', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('HTML Content Before Items', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_enabled_page_desc_top'
                        ),
                        'settings_gpls_woo_rfq_page_desc_top' => array(
                            'name' => '',
                            'type' => 'gpls_woo_html_editor',
                            'desc' => __('HTML at the beginning of the page which is after page title, before the list of items.', 'rfqtk'),
                            'default' => '',
                            'textarea_rows' => 10,
                            'editor_css' => '<style>#wp-settings_gpls_woo_rfq_page_desc_top-wrap{height:100px; width:600px;}</style>',
                            'id' => 'settings_gpls_woo_rfq_page_desc_top',

                        ),
                        'settings_gpls_woo_rfq_enabled_page_desc_bottom' => array(
                            'name' => '2- ' . __('Enable In Request for Quote Page', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('HTML Content At Page End', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_enabled_page_desc_bottom'
                        ),
                        'settings_gpls_woo_rfq_page_desc_bottom' => array(
                            'name' => '',
                            'type' => 'gpls_woo_html_editor',
                            'textarea_rows' => 10,
                            'desc' => __('HTML at end of the page after the submit quote button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'gpls_woo_plus_htm_editor_wide',
                            'id' => 'settings_gpls_woo_rfq_page_desc_bottom',

                        ),


                        'rfq_cart_sc_html_desc_section_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_html_desc_section_title_end'
                        ),

                        'rfq_cart_sc_misc_section_title' => array(
                            'name' => '',
                            'type' => 'title',
                            'desc' => __('<h1>MISC</h1>', 'rfqtk'),
                            'id' => 'rfq_cart_sc_misc_section_title',
                            'css' => 'width:600px'
                        ),
                        'settings_gpls_woo_rfq_plus_normal_checkout_redirect_anon' => array(
                            'name' => '1- Normal Checkout only ' . __('Require to login or register before submitting quote', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Require to login or register before submitting quote', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_plus_normal_checkout_redirect_anon'
                        ),
                        'settings_gpls_woo_rfq_plus_normal_checkout_redirect_anon_text' => array(
                            'name' => '',
                            'type' => 'gpls_woo_html_editor',
                            'textarea_rows' => 10,
                            'desc' => __('Message to user in the login page.', 'rfqtk'),
                            'default' => 'PLease log in or register to access the quote request page.',
                            'class' => 'gpls_woo_plus_htm_editor_wide',
                            'id' => 'settings_gpls_woo_rfq_plus_normal_checkout_redirect_anon_text',

                        ),

                        'settings_gpls_woo_rfq_allow_in_single' => array(
                            'name' => '3- Normal Checkout ' . __('Allow quote request submission in single product page.', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('This will only work for quote items', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_allow_in_single'
                        ),

                        'settings_gpls_woo_rfq_remove_update_cart_in_rfq_cart' => array(
                            'name' => '4- ' . __('Minimal RFQ Cart. Remove update button and remove item in quote request cart', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Use a minimal RFQ Cart. User can set quantity to zero to remove items. The only button is submit quote', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_remove_update_cart_in_rfq_cart'
                        ),
                        'rfq_cart_sc_misc_section_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_misc_section_title_end'
                        ),
                        'rfq_cart_sc_misc_section_widget_title' => array(
                            'name' => '',
                            'type' => 'title',
                            'desc' => __('<h1>Quote Cart Widget</h1>', 'rfqtk'),
                            'id' => 'rfq_cart_sc_misc_section_widget_title',
                            'css' => 'width:600px'
                        ),


                        'settings_gpls_woo_rfq_hide_quote_cart' => array(
                            'name' => '1- ' . __('Toggle RFQ Cart Widget on Mouse Hover', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Toggle RFQ Cart Widget Visibility on Mouse Hover', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_hide_quote_cart'
                        ),


                        'settings_gpls_woo_rfq_hide_quote_cart_position_right' => array(
                            'name' => '3- ' . __('Widget Position From the Right of the Header Area', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Put a number in Px or % of the deader area from the right', 'rfqtk'),
                            'default' => '14%',
                            'id' => 'settings_gpls_woo_rfq_hide_quote_cart_position_right'
                        ),

                        'rfq_cart_sc_misc_section_title_widget_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_misc_section_title_widget_end'
                        ),


                    )
                    +
                    array_slice($settings, count($settings) - 2, count($settings) - 1, true);;
                break;

            case 'rfq_checkout':
                $settings = array_slice($settings, 0, count($settings) - 1, true)

                    + array(
                        'settings_gpls_woo_rfq_combine_cart_checkout_title' => array(
                            'name' => '',
                            'type' => 'title',
                            'desc' => __('<h1>Combine Cart and Checkout</h1>', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_combine_cart_checkout_title',
                            'css' => 'width:600px'
                        ),
                        'settings_gpls_woo_rfq_combine_cart_checkout' => array(
                            'name' => __('Beta feature: Combine cart and checkout page', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Beta feature: You can simplify the checkout by showing the cart in the checkout page. <br />
                             If this option is selected, all requests to cart is redirected to checkout.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_combine_cart_checkout'
                        ),
                        'settings_gpls_woo_rfq_combine_cart_checkout_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'settings_gpls_woo_rfq_combine_cart_checkout_title_end'
                        ),

                        'rfq_cart_sc_section_title' => array(
                            'name' => __('Customize the WooCommerce checkout page for RFQ checkout', 'rfqtk'),
                            'type' => 'title',
                            'desc' => __('<p>You can simplify the checkout fields by making selected standard WooCommerce checkout fields (phone, company name, address, country, city, state and zip) either optional or hidden</p>                                            
                                            <p>This feature is only available in the following setups:
                                            <ul>
                                            <i> RFQ checkout</i>
                                            <i> RFQ checkout with option 5 and 5C both checked</i>
                                            <i> RFQ checkout with option 5 without 5C is not available for this option</i>
                                            </ul>
                                            </p>', 'rfqtk'),

                            'id' => 'rfq_cart_sc_section_title',
                            'css' => 'width:600px'
                        ),


                        'rfq_cart_sc_section_title_end2' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_section_title_end'
                        ),
                        'rfq_cart_sc_update_button_section_page_title_rfq' => array(
                            'name' => __('RFQ Checkout fields', 'rfqtk'),
                            'type' => 'title',
                            'desc' => '',
                            'id' => 'rfq_cart_sc_update_button_section_page_title',
                            'css' => 'width:600px'
                        ),


                        'rfq_cart_sc_section_nf_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_section_nf_end'
                        ),

                        'rfq_cart_sc_visitor_section_title_rfq' => array(
                            'name' => '',
                            'type' => 'title',
                            'desc' => __('<h1>Hide or make the following fields in WooCommerce checkout.</h1>', 'rfqtk'),
                            'id' => 'rfq_cart_sc_visitor_section_title_rfq',
                            'css' => 'width:600px'
                        ),

                        'rfq_cart_sc_section_rfq_page_phone_hide_rfq' => array(
                            'name' => '1- ' . __('Hide Phone', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_phone_hide_rfq',
                            'css' => 'width:400px;'
                        ),

                        'rfq_cart_sc_section_rfq_page_phone_optional_rfq' => array(
                            'name' => '1A- ' . __('Phone Optional', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_phone_optional_rfq',
                            'css' => 'width:400px;'
                        ),

                        'rfq_cart_sc_section_rfq_page_company_hide_rfq' => array(
                            'name' => '2- ' . __('Hide Company', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_company_hide_rfq',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_company_optional_rfq' => array(
                            'name' => '2A- ' . __('Company Optional', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_company_optional_rfq',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_country_hide_rfq' => array(
                            'name' => '3- ' . __('Hide Country', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_country_hide_rfq',
                            'css' => 'width:400px;'
                        ),

                        'rfq_cart_sc_section_rfq_page_country_optional_rfq' => array(
                            'name' => '3A- ' . __('Country Optional', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_country_optional_rfq',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_state_hide_rfq' => array(
                            'name' => '4- ' . __('Hide State', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_state_hide_rfq',
                            'css' => 'width:400px;'
                        ),

                        'rfq_cart_sc_section_rfq_page_state_optional_rfq' => array(
                            'name' => '4A- ' . __('State Optional', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_state_optional_rfq',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_address_hide_rfq' => array(
                            'name' => '5- ' . __('Hide Address', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_address_hide_rfq',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_address_optional_rfq' => array(
                            'name' => '5A- ' . __('Address Optional', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_address_optional_rfq',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_city_hide_rfq' => array(
                            'name' => '6- ' . __('Hide City', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_city_hide_rfq',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_city_optional_rfq' => array(
                            'name' => '6A- ' . __('City Optional', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_city_optional_rfq',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_zip_hide_rfq' => array(
                            'name' => '7- ' . __('Hide Zip', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_zip_hide_rfq',
                            'css' => 'width:400px;'
                        ),
                        'rfq_cart_sc_section_rfq_page_zip_optional_rfq' => array(
                            'name' => '7A- ' . __('Zip Optional', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => '',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_zip_optional_rfq',
                            'css' => 'width:400px;'
                        ),


                        'rfq_cart_sc_section_page_fields_end2' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_section_page_title_end'
                        ),


                    )
                    +
                    array_slice($settings, count($settings) - 2, count($settings) - 1, true);;
                break;


            case 'add-to-quote':
                $settings = array_slice($settings, 0, count($settings) - 1, true)

                    + array(


                        'rfq_cart_short_sc_section_title2' => array(
                            'name' => __('Add to Quote Shortcode', 'rfqtk'),
                            'type' => 'title',
                            'desc' => '<b>' . __('In the <b>normal checkout</b> mode you can create a "add to quote" button with <br />[gpls-woo-rfq-quote-button product_id=\'115\' show_image=\'yes\' image_size=\'thumbnail\' include_quantity=\'yes\' show_title=\'yes\' div_width=\'200px\']<i>.<br /> The sizes include thumbnail,shop_thumbnail, shop_catalog and shop_single. 
                                            The resulting image size depends on your shop settings for these images. The short code does not resize the image.<br /><br />
                                            In the <b>RFQ mode</b> use [add_to_cart id="115" style="border:4px solid #ccc; padding: 12px" sku="FOO" show_price="true" class="CSS-CLASS" include_quantity="no"]' . '</b>', 'rfqtk'),
                            'id' => 'rfq_cart_short_sc_section_title2',
                            'css' => 'width:600px'
                        ),
                        'rfq_cart_sc_section_add_to_quote_short_title_end2' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_section_add_to_quote_short_title_end2'
                        ),
                        'ninja_rfq_badge_section_title' => array(
                            'name' => __('Badge for Quote Items', 'rfqtk'),
                            'type' => 'title',
                            'desc' => __('Badge for quote items for easier identification', 'rfqtk'),
                            'id' => 'ninja_rfq_badge_section_title'
                        ),
                        'rfq_cart_sc_section_rfq_page_rfq_badge_use' => array(
                            'name' => '1- ' . __('Use a Badge for Quote Items?', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_rfq_badge_use'
                        ),
                        'rfq_cart_sc_section_rfq_page_rfq_badge_no_use_product' => array(
                            'name' => '1- ' . __('Disable the Badge in single product page?', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('', 'rfqtk'),
                            'default' => 'yes',
                            'id' => 'rfq_cart_sc_section_rfq_page_rfq_badge_no_use_product'
                        ),
                        'rfq_cart_sc_section_rfq_page_rfq_badge_use_position' => array(
                            'name' => __('Choose the position of "add to quote" in the shop and archive', 'woo-rfq-for-woocommerce'),
                            'type' => 'select',
                            'options' => array(
                                'woocommerce_after_shop_loop_item' => __('At the bottom', 'woo-rfq-for-woocommerce'),
                                'woocommerce_before_shop_loop_item' => __('At the top', 'woo-rfq-for-woocommerce'),
                                'woocommerce_before_shop_loop_item_title' => __('Before the title', 'woo-rfq-for-woocommerce'),
                                'woocommerce_shop_loop_item_title' => __('After title', 'woo-rfq-for-woocommerce')
                            ),
                            'desc' => "<br />" . __('Default position is at the bottom.".', 'woo-rfq-for-woocommerce'),
                            'default' => 'woocommerce_after_shop_loop_item',
                            'id' => 'rfq_cart_sc_section_rfq_page_rfq_badge_use_position'
                        ),

                        'rfq_cart_sc_section_rfq_page_rfq_badge_background' => array(
                            'name' => '2- ' . __('Badge Background Color', 'rfqtk'),
                            'type' => 'text',
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_rfq_badge_background',
                        ),
                        'rfq_cart_sc_section_rfq_page_rfq_badge_color' => array(
                            'name' => '2- ' . __('Badge Text Color', 'rfqtk'),
                            'type' => 'text',
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_rfq_badge_color',
                        ),

                        'rfq_cart_sc_section_rfq_page_rfq_badge_bold' => array(
                            'name' => '1- ' . __('Bold Font', 'rfqtk'),
                            'type' => 'checkbox',
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_rfq_page_rfq_badge_bold'
                        ),

                        'rfq_cart_sc_section_rfq_page_rfq_badge_text' => array(
                            'name' => '3- ' . __('Badge for Quote Items', 'rfqtk'),
                            'type' => 'text',
                            'default' => "",
                            'id' => 'rfq_cart_sc_section_rfq_page_rfq_badge_text',
                        ),

                        'rfq_cartninja_rfq_badgesection_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cartninja_rfq_badgesection_title_end'
                        ),

                        'ninja_section_title' => array(
                            'name' => __('Normal Checkout Add to Quote Button Style.', 'rfqtk'),
                            'type' => 'title',
                            'desc' => __('Style add to quote button', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_add-to-quote_section_title'
                        ),

                        'rfq_cart_sc_section_rfq_page_add_to_quote_button_background' => array(
                            'name' => '1- ' . __('Add to Quote Button Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Background color of add to quote button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_add_to_quote_button_background',
                        ),

                        'rfq_cart_sc_section_rfq_page_add_to_quote_button_color' => array(
                            'name' => '2- ' . __('Add to Quote Button Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Font color of Quote button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_add_to_quote_button_color',
                        ),
                        'rfq_cart_sc_section_rfq_page_add_to_quote_button_mouse_over_background' => array(
                            'name' => '3- ' . __('Add to Quote Button MouseOver Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Background color of Upload button when you move the mouse over it.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_add_to_quote_button_mouse_over_background',
                        ),
                        'rfq_cart_sc_section_rfq_page_add_to_quote_button_mouse_over_color' => array(
                            'name' => '4-' . __('Add to Quote Button MouseOver Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Font color of Quote button when you move the mouse over it.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_add_to_quote_button_mouse_over_color',
                        ),

                        'settings_gpls_woo_rfq_only_on_single_page_normal' => array(
                            'name' => '5- ' . __('Normal Checkout Only. Show "Add To Quote" only on single product Page', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Normal Checkout Only. Some themes only show "Add to Cart" in the single page.<br /> This would show "Add To Quote" only on single product Page.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_only_on_single_page_normal'
                        ),
                        'settings_gpls_woo_quote_only_on_single_page_normal' => array(
                            'name' => '6- ' . __('Normal Checkout Only. For Quote Items Show "Add To Quote" only on single product Page', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Normal Checkout Only. For Quote Items This would show "Add To Quote" only on single product Page.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_quote_only_on_single_page_normal'
                        ),

                        'settings_gpls_woo_rfq_only_on_single_page_rfq' => array(
                            'name' => '7- ' . __('RFQ Checkout Only. Show "Add To Quote" only on single product Page', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('This would show "Add To Quote" only on single product Page.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_only_on_single_page_rfq'
                        ),
                        'rfq_cart_sc_redirect_after_add' => array(
                            'name' => '8- ' . __('Normal Checkout-Enable Redirect After Add to Quote For All Users', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Enable Redirect to RFQ Cart After Add to Quote For For All Users', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_redirect_after_add'
                        ),
                        'rfq_cart_sc_redirect_to_single' => array(
                            'name' => '9- ' . __('Always redirect the user to the single product page', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Always redirect the user to the single product page', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_redirect_to_single'
                        ),



                        'rfq_cart_sc_section_add_to_quote_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_section_add_to_quote_title_end'
                        )) +
                    array_slice($settings, count($settings) - 2, count($settings) - 1, true);

                break;


            case 'email-options':
                $settings = array(


                    'general_section_title0' => array(
                        'name' => __('Proposal Content', 'rfqtk'),
                        'type' => 'title',
                        'desc' => __('Custom HTML content to be included with each proposal', 'rfqtk'),
                        'id' => 'general_section_title0'
                    ),
                    'settings_gpls_woo_rfq_default_proposal_content' => array(
                        'name' => __('Default Proposal HTML Content', 'rfqtk'),
                        'type' => 'gpls_woo_html_editor',
                        'textarea_rows' => 10,
                        'desc' => __('Default Proposal HTML Content. You can modify this before sending', 'rfqtk'),
                        'default' => '',
                        'class' => 'gpls_woo_plus_htm_editor_wide',
                        'id' => 'settings_gpls_woo_rfq_default_proposal_content',
                    ),

                    'settings_gpls_woo_rfq_global_proposal' => array(
                        'name' => '' . __('HTML Content appended to each proposal sent to customer', 'rfqtk'),
                        'type' => 'gpls_woo_html_editor',
                        'textarea_rows' => 5,
                        'desc' => __('Custom HTML content to be included at the end of each proposal.', 'rfqtk'),
                        'default' => "",
                        'class' => 'gpls_woo_plus_htm_editor_wide',
                        'id' => 'settings_gpls_woo_rfq_global_proposal',
                    ),
                    'settings_settings_gpls_woo_rfq_global_proposal_section_end33' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end33'
                    ),
                    'general_section_title0000' => array(
                        'name' => __('Email Options', 'rfqtk'),
                        'type' => 'title',
                        'desc' => __('links in the "Quote Sent" Email ', 'rfqtk'),
                        'id' => 'general_section_title0000'
                    ),
                    'settings_gpls_woo_rfq_pay_default' => array(
                        'name' => '1- ' . __('Check Pay Link For All Proposals', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Check Pay Link For All Proposals.  You can override this for individual order.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_pay_default'
                    ),
                    'settings_gpls_woo_rfq_respond_default' => array(
                        'name' => '2- ' . __('Check Respond Link For All Proposals', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Check Respond Link For All Proposals. You can override this for individual order.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_respond_default'
                    ),

                    'settings_gpls_woo_rfq_accept_default' => array(
                        'name' => '3- ' . __('Check Accept Link For All Proposals', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Check Accept Link For All Proposals. You can override this for individual order.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_accept_default'
                    ),

                    'settings_gpls_woo_rfq_show_accept_offer' => array(
                        'name' => '4- ' . __('Show Accept Offer Form to Customer', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Show "accept offer" form to customer in the order screen in my-account. You can override this for individual order.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_show_accept_offer'),

                    'settings_gpls_woo_rfq_multiple_offers_default' => array(
                        'name' => '4- ' . __('Allow customer to accept multiple offers', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Allow customer to accept multiple offers. By default customer can\'t accept a new offer after accepting the first one.<br />  You can override this for individual order.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_multiple_offers_default'),


                    'settings_gpls_woo_rfq_expire_method' => array(
                        'name' => '5- ' . __('Quote Expiration Option', 'rfqtk'),
                        'type' => 'select',
                        'options' => array(
                            'no' => __('No Expiration', 'rfqtk'),
                            'wc-cancelled' => __('Cancel Quotes', 'rfqtk'),
                            'trash' => __('Move Quotes to Trash', 'rfqtk')),
                        'desc' => "<br />" . __('Choose if you want to expire the quote request after a length of time.<br />   You can override this for individual order.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_expire_method'),

                    'settings_gpls_woo_rfq_expire_days' => array(
                        'name' => '6- ' . __('Number of Days Before Quote Expires( Greater than 1 day is required)', 'rfqtk'),
                        'type' => 'number',
                        'desc' => "<br />" . __('Number of Days Before Quote Expires. Put a number greater than 1', 'rfqtk'),
                        'default' => '30',
                        'id' => 'settings_gpls_woo_rfq_expire_days',
                        'css' => 'width:100px'
                    ),
                    'settings_gpls_woo_rfq_order_date' => array(
                        'name' => '7- ' . __('Update Order Date On Completion?', 'rfqtk'),
                        'type' => 'select',
                        'options' => array(
                            'no' => __('No. Keep the original Date', 'rfqtk'),
                            'yes' => __('Yes. Update order date to order payment date', 'rfqtk')),
                        'desc' => "<br />" . __('Update order date to payment date for quote requests".', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_order_date'),

                    'settings_gpls_woo_rfq_admin_email_reply_to' => array(
                        'name' => '8- ' . __('Change "reply to" in admin email to customer email', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Change "reply to" to the customer billing email in emails sent to admin for convenience.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_admin_email_reply_to',
                        'css' => 'width:400px;'
                    ),

                    'settings_gpls_woo_rfq_quote_sent_email_customer_notes' => array(
                        'name' => '9- ' . __('Include Customer Notes In Quote Sent Email', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Include all the cutomer notes in the "Quote Sent" (proposal) email..', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_quote_sent_email_customer_notes',
                        'css' => 'width:400px;'
                    ),

                    'settings_gpls_woo_rfq_show_prices_customer_confirmation_email' => array(
                        'name' => '10- ' . __('Show Prices in Customer Quote Request Email Confirmation.', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Include prices in the request for quote confirmation email.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_show_prices_customer_confirmation_email'
                    ),

                    'settings_gpls_woo_rfq_email_new_rfq_cc' => array(
                        'name' => '10- ' . __('CC New Quote Recieved Confirmation Customer Email. Seperate with commas)', 'rfqtk'),
                        'type' => 'text',
                        'desc' => "<br />" . __('CC these emails in addition to customer when a new quote request recieved confirmation is sent to customer', 'rfqtk'),
                        'default' => '',
                        'id' => 'settings_gpls_woo_rfq_email_new_rfq_cc',
                        'css' => 'width:600px'
                    ),

                    'settings_gpls_woo_rfq_show_shipping_email' => array(
                        'name' => '12- ' . __('Include shipping address in quote emails.', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Include shipping address in quote emails.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_show_shipping_email'
                    ),

               /*     'settings_gpls_woo_rfq_email_css' => array(
                        'name' => '13- ' .__('CSS For the Quote Emails', 'rfqtk'),
                        'type' => 'textarea',
                        'desc' => 'You can add css for all the quote emails. For example: .your_class{visibility: hidden;}',
                        'id' => 'settings_gpls_woo_rfq_email_css',
                        'css' => 'width:600px;height:100px;vertical-align: top'
                    ),*/

                    'settings_gpls_woo_rfq_import_order_items_table' => array(
                        'name' => '14- ' . __('Import Order Items Table Into the Proposal', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Import order items table (similar to what goes out in the email) into the proposal.<br />  This can be edited to be included in the porposal', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_import_order_items_table'
                    ),
                    'settings_gpls_woo_rfq_import_order_items_table_desc' => array(
                        'name' => '15- ' . __('Show product descriptions in the Order Items Table', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Show product descriptions in the Order Items Table', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_import_order_items_table_desc'
                    ),

                    'settings_gpls_woo_rfq_accept_offer_order_status' => array(
                        'name' => '16- ' . __('Change Order Status when customer accepts offer. It only works if order status is in "Quote Sent" ', 'rfqtk'),
                        'type' => 'select',
                        'options' => array(
                            'no' => __('No Change', 'rfqtk'),
                            'wc-pending' => __('pending', 'rfqtk'),
                            'wc-processing' => __('processing', 'rfqtk'),
                            'wc-completed' => __('completed', 'rfqtk')),
                        'desc' => "<br />" . __('Choose if you want to change order-status when customer accepts offer.<br /> It only works if order status is in "Quote Sent"', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_accept_offer_order_status'),

                    'settings_settings_gpls_woo_rfq_global_proposal_section_end333' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end333'
                    ),
                    'general_section_title00' => array(
                        'name' => __('Automated Quote Handling', 'rfqtk'),
                        'type' => 'title',
                        'desc' => __('Automatically convert quote requests status.', 'rfqtk'),
                        'id' => 'general_section_title00'
                    ),
                    'settings_gpls_woo_rfq_quote_request_change_order_status' => array(
                        'name' => '0- ' . __('Automatically change Order Status when customer requests a quote. It only works if order status is in "Quote Request" ', 'rfqtk'),
                        'type' => 'select',
                        'options' => array(
                            'no' => __('No Change', 'rfqtk'),
                            'wc-pending' => __('pending', 'rfqtk'),
                            'wc-processing' => __('processing', 'rfqtk'),
                            'wc-completed' => __('completed', 'rfqtk')),
                        'desc' => "<br />" . __('Choose if you want to change order-status when customer requests a quote.<br /> 
                          It only works if order status is in "Quote Request". <br /> Customer will still recieve the "quote received confirmation unless you disable <br /> 
                           the "RFQ-ToolKit New Request for Quote" email in WooCommerce->settings->email screen.<br />  If this option is selected, options 1-4 will not run."', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_quote_request_change_order_status'),

                    'settings_gpls_woo_rfq_quote_request_change_order_status_notify' => array(
                        'name' => '1- ' . __('Send customer email notification automatically', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('If you have selected an option above, you can choose to notify the customer of the status change.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_quote_request_change_order_status_notify'
                    ),
                    'settings_gpls_woo_rfq_change_to_sent' => array(
                        'name' => '2- ' . __('Convert all New Quote Request to "Quote Sent" automatically', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('PLEASE BE CAREFUL WITH THIS OPTION. IF AN ITEM IN THE ORDER HAS ZERO OR NO PRICE,<br />CUSTOMER WILL RECIEIVE A 100% DISCOUNT ON THAT ITEM.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_change_to_sent'
                    ),

                    'settings_gpls_woo_rfq_change_to_sent_limit' => array(
                        'name' => '3- ' . __('Minimum purchase to allow automatic Quote Request Conversion(This works with option 15 above.<br />  Leave blank if no minimum)', 'rfqtk'),
                        'type' => 'number',
                        'desc' => "<br />" . __('Minimum purchase to allow Quote Request Conversion', 'rfqtk'),
                        'default' => '',
                        'id' => 'settings_gpls_woo_rfq_change_to_sent_limit',
                        'css' => 'width:100px'
                    ),


                    'settings_gpls_woo_rfq_delay_quote_hours' => array(
                        'name' => '4- ' . __('Number of Hours Before Quote Is Sent automatically', 'rfqtk'),
                        'type' => 'text',
                        'desc' => "<br />" . __('Put a number for number of hours before quote is sent. Example: 1,0.5 or 1.5.<br />  Initial Confirmation email is also sent.<br />  If blank, quote is sent with a 5 minutes delay', 'rfqtk'),
                        'default' => '',
                        'id' => 'settings_gpls_woo_rfq_delay_quote_hours',
                        'css' => 'width:100px'
                    ),

                    'settings_settings_gpls_woo_rfq_global_proposal_section_end33300' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end33300'
                    ),


                );
                break;


            case 'marketing':
                $settings = array(

                    'general_section_title1' => array(
                        'name' => __('Marketing Content For Email & Thank You Page', 'rfqtk'),
                        'type' => 'title',
                        'desc' => '<h4>' . __('Marketing content can in be included as HTML in confirmation emails and the thank you page.
 <br />Content can be included in two ways: 
 <br /> 1: You can enter content in product set-up in the advanced tab of product setup.
 <br />2: You can also include a custom global content ( for all products) or by category in this page below. ', 'rfqtk') . '</h4>',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_title2'
                    ),

                    'settings_gpls_woo_rfq_customer_confirmation_section_end33' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end33'
                    ),
                    'general_section_end332eee' => array(
                        'type' => 'sectionend',
                        'id' => 'general_section_end332eee'
                    ),


                    'general_section_title22' => array(
                        'name' => __('Enable / Disable Product-Specific Marketing Content Options', 'rfqtk'),
                        'type' => 'title',
                        'desc' => '<h4>' . __('Manage product-specific custom content in the confirmation email and thank you page.', 'rfqtk') . '</h4>',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_title'
                    ),

                    'gpls_woo_rfq_customer_confirmation_product_thankyou_page' => array(
                        'name' => '1- ' . __('Include Product-Specific Content in The Thank You Page.', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('This option enables/disables product-specific marketing globally in the thank you pages.<br />If this option is not checked no custom content is included in the thank you page.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'gpls_woo_rfq_customer_confirmation_product_thankyou_page'
                    ),
                    'gpls_woo_rfq_email_confirmation_product_messages' => array(
                        'name' => '2- ' . __('Show Product-Specific Content in Request Recieved and Quote Sent Email Confirmation', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('This option enables/disables product marketing in Email confirmations.<br /> If this option is not checked no custom content is included in the confirmation emails.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'gpls_woo_rfq_email_confirmation_product_messages'
                    ),

                    'general_section_end3324' => array(
                        'type' => 'sectionend',
                        'id' => 'general_section_end3324'
                    ),
                    'general_section_end332' => array(
                        'type' => 'sectionend',
                        'id' => 'general_section_end332'
                    ),

                    'general_section233356_title' => array(
                        'name' => '=======================================================',
                        'type' => 'title',

                        'id' => 'general_section233356_title'
                    ),



                    'settings_gpls_woo_rfq_cats_new_enable_product_messages' => array(
                        'name' => '4- ' . __('Bulk Enable/Disable Product Marketing Content in the selected categories', 'rfqtk'),
                        'type' => 'gpls_woo_chkbox_prod_marketing_list',
                        'desc' => __('All new products created in selected categories will Product Marketing Content Enabled. <br />You can update the existing products by checking the option above.<br />
                             If option 2 above is checked, only the products in selected categories will have Product Marketing. You can still modify at product level.', 'rfqtk'),
                        'default' => '',
                        'id' => 'settings_gpls_woo_rfq_cats_new_enable_product_messages',
                        'css' => 'width:600px;height:100px;vertical-align: top'
                    ),

                    'settings_gpls_woo_rfq_customer_confirmation_section_end335' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end335'
                    ),



                    'general_section_title2266' => array(
                        'name' => __('Update Marketing Content for Products by Category', 'rfqtk'),
                        'type' => 'title',
                        'desc' => '<h4>' . __('Update Marketing Content for Products by Category. Content can also be update individually in product setup.', 'rfqtk') . '</h4>',
                        'id' => 'general_section_title2266'
                    ),

                    'settings_gpls_woo_rfq_customer_product_message_content' => array(
                        'name' => '1- ' . __('HTML Content For Products in Selected Categories Email Confirmation/Thank You Page', 'rfqtk'),
                        'type' => 'gpls_woo_html_editor',
                        'textarea_rows' => 10,
                        'desc' => __('HTML Content For Products in Selected Categories to be included in confirmation emails and thank you page.<br />', 'rfqtk'),
                        'default' => '',
                        'class' => 'gpls_woo_plus_htm_editor_wide',
                        'id' => 'settings_gpls_woo_rfq_customer_product_message_content',
                    ),

                    'settings_gpls_woo_rfq_cats_new_update_product_messages' => array(
                        'name' => '2- ' . __('Bulk Update Product Marketing Content for Existing products in the selected categories', 'rfqtk'),
                        'type' => 'gpls_woo_chkbox_prod_marketing_content_list',
                        'desc' => __('Bulk update product marketing content for selected categories above.', 'rfqtk'),
                        'default' => '',
                        'id' => 'settings_gpls_woo_rfq_cats_new_update_product_messages',
                        'css' => 'width:600px;height:100px;vertical-align: top'
                    ),

                    'settings_gpls_woo_prod_marketing_by_category' => array(
                        'name' => __('Marketing Content for Products by Category', 'rfqtk'),
                        'type' => 'gpls_woo_prod_marketing_by_category',
                        'desc' => '<h4>' . __('Marketing Content for Products by Category.', 'rfqtk') . '</h4>',
                        'id' => 'settings_gpls_woo_prod_marketing_by_category'
                    ),


                    'settings_gpls_woo_rfq_customer_confirmation_section_end3357' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end3357'
                    ),
                    'general_section_end332o9' => array(
                        'type' => 'sectionend',
                        'id' => 'general_section_end332o9'
                    ),

                    'general_section2333tt_title' => array(
                        'name' => '=======================================================',
                        'type' => 'title',

                        'id' => 'general_section2333tt_title'
                    ),
                    'general_section_title2264' => array(
                        'name' => __('Send  Email for Each Product', 'rfqtk'),
                        'type' => 'title',
                        'desc' => '<h4>' . __('Send an email for each product.', 'rfqtk') . '</h4>',
                        'id' => 'general_section_title2264'
                    ),
                    'gpls_woo_rfq_email_product_marketing_emails' => array(
                        'name' => '1- ' . __('Send an email for each product-specific marketing content. This sends an email for each product, but does not include a quote. This is an informational email only.', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Send an email for each product-specific marketing content.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'gpls_woo_rfq_email_product_marketing_emails'
                    ),
                    'settings_gpls_woo_rfq_delay_product_marketing_hours' => array(
                        'name' => '2- ' . __('Number of Hours Before EmailIs Sent automatically', 'rfqtk'),
                        'type' => 'text',
                        'desc' => "<br />" . __('Put a number for number of hours before email is sent. Example: 1,0.5 or 1.5. Default is 5 minutes delay', 'rfqtk'),
                        'default' => '',
                        'id' => 'settings_gpls_woo_rfq_delay_product_marketing_hours',
                        'css' => 'width:100px'
                    ),

                    'settings_gpls_woo_rfq_customer_confirmation_section_end300' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end300'
                    ),

                    'general_section_end332fff' => array(
                        'type' => 'sectionend',
                        'id' => 'general_section_end332fff'
                    ),

                    'general_section233e4r3_title' => array(
                        'name' => '=======================================================',
                        'type' => 'title',
                        'id' => 'general_section233e4r3_title'
                    ),

                    'general_section_title333' => array(
                        'name' => __('Global Custom Content For All Products', 'rfqtk'),
                        'type' => 'title',
                        'desc' => '<h4>' . __('Manage global custom content in confirmation emails and confirmation pages', 'rfqtk') . '</h4>',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_title'
                    ),

                    'gpls_woo_rfq_customer_confirmation_stock_thankyou_page' => array(
                        'name' => '1- ' . __('Show The Content Below in Request Recieved / Thank You Page', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Custom content to show the customer in the thank you page after request for quote is submitted.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'gpls_woo_rfq_customer_confirmation_stock_thankyou_page'
                    ),
                    'gpls_woo_rfq_email_confirmation_stock_message' => array(
                        'name' => '2- ' . __('Show The Content Below in Request Recieved Email Confirmation', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Custom content to show the customer in the email confirmation after request for quote is submitted. ', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'gpls_woo_rfq_email_confirmation_stock_message'
                    ),


                    'settings_gpls_woo_rfq_customer_confirmation_message' => array(
                        'name' => '3- ' . __('HTML Content to Customers in Email Confirmation/Thank You Page', 'rfqtk'),
                        'type' => 'gpls_woo_html_editor',
                        'textarea_rows' => 10,
                        'desc' => __('Custom HTML content to be included in confirmation emails and thank you page.', 'rfqtk'),
                        'default' => '',
                        'class' => 'gpls_woo_plus_htm_editor_wide',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_message',
                    ),
                    'settings_gpls_woo_rfq_customer_confirmation_section_end21' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_confirmation_section_end21'
                    ),

                );
                break;

            case 'custom-form':


                $settings =

                    array(

                        'ninja_section_title' => array(
                            'name' => __('Custom Form Integration.', 'rfqtk'),
                            'type' => 'title',
                            'desc' => '<h3>' . __('Add your own fields to checkout(RFQ checkout) or quote request page(normal checkout) using a Ninja Form.', 'rfqtk') . '</h3>'
                                . '<ul><li><b>' . __('Compatibe with Ninja Forms version 3.0.', 'rfqtk') . '</b></li>'
                                . '<li><b>' . __('Supports <u><i>most standard fields and basic features(Not paid e.g file upload or third party extensions)</i></u> included with Ninja Forms 3.0.', 'rfqtk') . '</b></li>'
                                . '<li><b>' . __('Note: Must include a Submit Button in your Ninja Form.', 'rfqtk') . '</b></li>'
                                . '<li><b>' . __('Note: Calculated fields are not saved in the order.', 'rfqtk') . '</b></li>'
                                . '<li><b>' . __('Note: “CUSTOM NAME ATTRIBUTE” must be blank. Ninja Form sometimes(e.g city, zip) adds a value to “CUSTOM NAME   ATTRIBUTE” when you add a field. <br />This is found in the ADVANCED section of the field settings..', 'rfqtk') . '</b></li>'

                                . '<li><b>' . __('Note: Plugin saves the values entered by the user in the order.', 'rfqtk') . '</b></li></ul>',
                            'id' => 'settings_gpls_woo_rfq_ninja_section_title'
                        ),
                        'settings_gpls_woo_rfq_allow_custom_form' => array(
                            'name' => '1- ' . __('Applicable to RFQ Checkout & Normal. Display Custom Form for quote request checkout', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Applicable to RFQ Checkout & Normal. Enable Custom Form For Quote Request Checkout', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_allow_custom_form'
                        ),
                        'settings_gpls_woo_rfq_allow_custom_form_wc' => array(
                            'name' => '2- ' . __('Applicable to Normal Checkout Only: Display Custom Form in WooCommerce Checkout for regular orders ', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Enable Custom Form in WooCommerce checkout for regular orders', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_allow_custom_form_wc'
                        ),

                        'settings_gpls_woo_ninja_form_option' => array(
                            'name' => '3- ' . __('Select Ninja Form', 'rfqtk'),
                            'type' => 'select',
                            'options' => gpls_woo_rfq_plus_get_ninja_forms(),
                            'desc' => '<br />' . __('Choose a Ninja form <b>version 3.0</b> to use for Additional inquries/information.
<br />  Note: Form must have a submit button. Calculated fields, Recaptcha or Anti-Spam are ignored and can break the integration with this plugin.', 'rfqtk'),
                            'default' => '',
                            'id' => 'settings_gpls_woo_ninja_form_option'
                        ),

                        'settings_gpls_woo_rfq_ninja_form_position' => array(
                            'name' => '4- ' . __('Applicable to RFQ Checkout Only: Ninja Form Position in WooCommerce Checkout Page.', 'rfqtk'),
                            'type' => 'select',
                            'options' => array(
                                '1' => __('Before Customer Information', 'rfqtk'),
                                '2' => __('After Customer Information', 'rfqtk'),
                                '3' => __('Before Order Review', 'rfqtk')),

                            'desc' => '<br />' . __('Applicable to RFQ Checkout Only. Choose position of the Ninja Form in the cart page.<br /> Your theme might not support all the positions or the placement might vary in your theme.', 'rfqtk'),
                            'default' => '1',
                            'id' => 'settings_gpls_woo_rfq_ninja_form_position'
                        ),

                        'rfq_cart_sc_section_nf_rfq_only' => array(
                            'name' => '5- ' . __('Allow Ninja Form in Checkout Only in RFQ mode?', 'rfqtk'),
                            'type' => 'select',
                            'options' => array(
                                'no' => __('Always show the Ninja Form in Woo checkout', 'rfqtk'),
                                'yes' => __('Show Ninja Form only in RFQ mode in Woo checkout', 'rfqtk')),

                            'desc' => __('.', 'rfqtk'),
                            'default' => 'no',
                            'id' => 'rfq_cart_sc_section_nf_rfq_only',
                            'css' => 'width:400px;'
                        ),


                        'ninja_section_end' => array(
                            'type' => 'sectionend',
                            'id' => 'settings_gpls_woo_rfq_ninja_section_end'
                        ),


                    );
                break;

            case 'customer-notes':
                $settings =

                    array(
                        'ninja_section_title' => array(
                            'name' => __('Allow customers to add notes to existing "quotes requests" and orders', 'rfqtk'),
                            'type' => 'title',
                            'desc' => '<h4>' . __('Allow customers to add notes to existing "quotes requests" and orders. Notes notifies the shop manager.', 'rfqtk') . '</h4>',
                            'id' => 'settings_gpls_woo_rfq_add-to-note_section_title'
                        ),
                        'settings_gpls_woo_rfq_customer_note_text_page' => array(
                            'name' => '0- ' . __('Use a Page For Customer Notes', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('By default there is no cutomer-respond page. If you want a specific page or if a page builder is having
                             problems with the customer response link, then checking this option, the plugin creates a page with the URL 
                             http(s)://yourdomain/customer-respond/. Please check the pages section and make sure the page is created. If for some reason, the page
                             is not there or deleted, simply create the page with URL http(s)://yourdomain/customer-respond/. 
                             The only content needed in the page is the shortcode <b>[gpls_woo_rfq_get_customer_response]</b> .
                             <a href="https://neahplugins.com/wp-content/uploads/customer-respond.png" target="_blank">Sample page</a> 
                              ', 'rfqtk')
                        ,
                            'default' => 'no',
                            'id' => 'settings_gpls_woo_rfq_customer_note_text_page'
                        ),

                        'settings_gpls_woo_rfq_customer_note_text' => array(
                            'name' => '1- ' . __('Label For Adding a Note', 'rfqtk'),
                            'type' => 'text',
                            'desc' => '',
                            'default' => __('Submit', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_customer_note_text',
                            'css' => 'width:600px'
                        ),

                        'rfq_cart_sc_section_rfq_page_add_customer_note_button_background' => array(
                            'name' => '2- ' . __('Order Notes Button Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Background color of add to order notes button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_add_customer_note_button_background',
                        ),

                        'rfq_cart_sc_section_rfq_page_add_customer_note_button_color' => array(
                            'name' => '3- ' . __('Add to Order Notes Button Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Font color of Order Notes button.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_add_customer_note_button_color',
                        ),
                        'rfq_cart_sc_section_rfq_page_add_customer_note_button_mouse_over_background' => array(
                            'name' => '4- ' . __('Add to Order Notes Button MouseOver Background Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Background color of Order Notes button when you move the mouse over it.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_add_customer_note_button_mouse_over_background',
                        ),
                        'rfq_cart_sc_section_rfq_page_add_customer_note_button_mouse_over_color' => array(
                            'name' => '5-' . __('Add to Order Notes Button MouseOver Font Color', 'rfqtk'),
                            'type' => 'text',
                            'desc' => __('Font color of Order Notes button when you move the mouse over it.', 'rfqtk'),
                            'default' => '',
                            'class' => 'color_picker',
                            'id' => 'rfq_cart_sc_section_rfq_page_add_customer_note_button_mouse_over_color',
                        ),

                        'settings_gpls_woo_rfq_show_notes' => array(
                            'name' => '6- ' . __('Allow customer notes in my account view order page', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('Enable Customer notes in my account for orders in "quote sent status"', 'rfqtk'),
                            'default' => 'yes',
                            'id' => 'settings_gpls_woo_rfq_show_notes'
                        ),

                        'settings_gpls_woo_rfq_num_of_notes' => array(
                            'name' => '7- ' . __('Number of notes on the dashboard. Greater than 1 is required)', 'rfqtk'),
                            'type' => 'number',
                            'desc' => "<br />" . __('Number of notes on the dashboard. Put a number greater than 1', 'rfqtk'),
                            'default' => '1',
                            'id' => 'settings_gpls_woo_rfq_num_of_notes',
                            'css' => 'width:100px'
                        ),
                        'settings_gpls_woo_rfq_limit_dashboard_notes' => array(
                            'name' => '8- ' . __('Show recent notes only for quote orders', 'rfqtk'),
                            'type' => 'checkbox',
                            'desc' => __('If unchecked, customer notes from any order status appear in the dashboard widget.', 'rfqtk'),
                            'default' => 'yes',
                            'id' => 'settings_gpls_woo_rfq_limit_dashboard_notes'
                        ),

                        'settings_gpls_woo_rfq_limit_dashboard_notes_title' => array(
                            'name' => '9- ' . __('Title for dashboard notes widget', 'rfqtk'),
                            'type' => 'text',
                            'desc' => '',
                            'default' => __('Recent Customer Notes', 'rfqtk'),
                            'id' => 'settings_gpls_woo_rfq_limit_dashboard_notes_title',
                            'css' => 'width:400px'
                        ),

                        'rfq_cart_sc_section_add_customer_note_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'rfq_cart_sc_section_add_customer_note_title_end'
                        ),


                    );
                break;

            case 'customer-offer':
                $settings = array(

                    'general_section_title' => array(
                        'name' => __('RFQ-ToolKit Customer Bid', 'rfqtk'),
                        'type' => 'title',
                        'desc' => '<h4>' . __('Allow customers to make a bid on the whole cart while submitting a request for quote', 'rfqtk') . '</h4><h4>This plugin also allows you to set min/max quantities for each product.</h4><h4>You can also select a product to be an exclusive item. Exclusive item has to be the only item in the quote request.</h4><h2>The settings for each product can be by category ( in the category edit) or in product advanced setup</h2>',
                        'id' => 'settings_gpls_woo_rfq_customer_offer_section_title'
                    ),


                    'settings_gpls_woo_rfq_allow_customer_offer' => array(
                        'name' => '1- ' . __('Allow Customer to Make an Offer', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Allow the customer to make an offer on the whole cart.<br /> The offer price is saved in the order and included in the email messages', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_allow_customer_offer'
                    ),
                    'settings_gpls_woo_rfq_make_customer_offer_required' => array(
                        'name' => '2- ' . __('Make Customer Offer Required', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Make customer offer a requried field.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_make_customer_offer_required'
                    ),


                    'settings_gpls_woo_rfq_customer_offer_text' => array(
                        'name' => '3- ' . __('Label For Make an Offer', 'rfqtk'),
                        'type' => 'text',
                        'desc' => '',
                        'default' => __('Make an Offer!', 'rfqtk'),
                        'id' => 'settings_gpls_woo_rfq_customer_offer_text',
                        'css' => 'width:600px'
                    ),
                    'settings_gpls_woo_rfq_customer_offer_desc' => array(
                        'name' => '4- ' . __('HTML Content for Make an Offer', 'rfqtk'),
                        'type' => 'gpls_woo_html_editor',
                        'textarea_rows' => 10,
                        'desc' => __('Instructions to customer for making an offer.', 'rfqtk'),
                        'default' => 'Make an offer!',
                        'editor_css' => '<style>#wp-settings_gpls_woo_rfq_customer_offer_desc-wrap{height:100px; width:600px;}</style>',
                        'id' => 'settings_gpls_woo_rfq_customer_offer_desc',

                    ),
                    'settings_gpls_woo_rfq_customer_offer_checkout_position' => array(
                        'name' => '5- ' . __('RFQ Checkout Only: Customer Offer Checkout Page Position', 'rfqtk'),
                        'type' => 'select',
                        'options' => array(
                            '1' => __('Before Order Totals Review', 'rfqtk'),
                            '2' => __('After Order Totals Review', 'rfqtk'),
                            '3' => __('Before Customer Information', 'rfqtk'),
                            '4' => __('After Customer Information', 'rfqtk')),
                        'desc' => '<br />' . __('Choose position of customer offer in the checkout page.<br /> Your theme might not support all the positions or the placement might vary in your theme.', 'rfqtk'),
                        'default' => '1',
                        'id' => 'settings_gpls_woo_rfq_customer_offer_checkout_position'
                    ),
                    'settings_gpls_woo_rfq_quote_sent_email_customer_offer' => array(
                        'name' => '6- ' . __('Include the Customer Offer In Quote Sent Email', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Include the cutomer offer in the "Quote Sent" (proposal) email..', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_quote_sent_email_customer_offer'
                    ),

                    'settings_gpls_woo_rfq_customer_confirmation_section_end' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_offer_section_section_end'
                    )
                );
                break;


            case 'sales-staff':
                $settings = array(

                    'general_section_title' => array(
                        'name' => __('Sales Staff Settings', 'rfqtk'),
                        'type' => 'title',
                        'desc' => '',
                        'id' => 'settings_gpls_woo_rfq_sales-staff_section_title'
                    ),
                    'settings_gpls_woo_rfq_allow_sales_staff_ip_filter' => array(
                        'name' => '1- ' . __('Enable Access by IP address', 'rfqtk'),
                        'type' => 'checkbox',
                        'desc' => __('Enabled Access by IP address.<br /> In the RFQ mode selected IP can view prices, buy or create a quote at woocommerce checkout. In the normal checkout selected IP can see all the prices.', 'rfqtk'),
                        'default' => 'no',
                        'id' => 'settings_gpls_woo_rfq_allow_sales_staff_ip_filter'
                    ),

                    'settings_gpls_woo_sales_staff_ips' => array(
                        'name' => '2- ' . __('IP List', 'rfqtk'),
                        'type' => 'gpls_woo_text_area',
                        'desc' => __('Add IP addresses seperated by commas:. <br /> * Network ranges can be specified as:<ul> <li>Wildcard format: 1.2.3.*</li> <li>CIDR format: 1.2.3/24  OR  1.2.3.4/255.255.255.0</li><li>Start-End IP format: 1.2.3.0-1.2.3.255.</li></ul>', 'rfqtk'),
                        'default' => '',
                        'id' => 'settings_gpls_woo_sales_staff_ips',
                        'css' => 'width:600px;height:100px;vertical-align: top'
                    ),

                    'settings_gpls_woo_rfq_sales_staff_section_end' => array(
                        'type' => 'sectionend',
                        'id' => 'settings_gpls_woo_rfq_customer_offer_section_section_end'
                    )


                );
                break;


            case 'rfq-toolkit-license':


                if (class_exists('GPLS_WOO_RFQ_PLUS')) {
                    $rfqtk_main_setting = array(
                        'name' => '',
                        'type' => 'title',
                        'desc' => '<a target="_blank" href="' . admin_url() . 'options-general.php?page=wc_api_manager_rfqtk_plus_dashboard">NP Quote Request WooCommerce Plus</a>',
                        'default' => '',
                        'id' => 'settings_gpls_woo_rfq_lic_page',

                    );

                } else {
                    $rfqtk_main_setting = array();
                }

                if (class_exists('GPLS_WOO_PDF')) {
                    $rfqtk_pdf_setting = array(
                        'name' => '',
                        'type' => 'title',
                        'desc' => '<a target="_blank" href="' . admin_url() . 'options-general.php?page=wc_api_manager_pdf_dashboard">NP PDF</a>',
                        'default' => '',
                        'id' => 'settings_gpls_woo_rfq_pdf_lic_page',

                    );

                } else {
                    $rfqtk_pdf_setting = array();
                }

                if (class_exists('GPLS_WOO_RFQ_UPLOAD')) {

                    $rfqtk_upload_setting = array(
                        'name' => '',
                        'type' => 'title',
                        'desc' => '<a target="_blank" href="' . admin_url() . 'options-general.php?page=wc_api_manager_rfqtk_upload_dashboard">NP Quote Request WooCommerce - File Upload</a>',

                        'default' => '',
                        'id' => 'settings_gpls_woo_rfq_upload_lic_page',

                    );

                } else {
                    $rfqtk_upload_setting = array();
                }

                if (class_exists('GPLS_WOO_RFQ_FIELD')) {
                    $rfqtk_field_setting = array(
                        'name' => '',
                        'type' => 'title',
                        'desc' => '<a target="_blank" href="' . admin_url() . 'options-general.php?page=wc_api_manager_rfqtk_field_dashboard">NP Quote Request WooCommerce - Custom Product Fields</a>',
                        'default' => '',
                        'id' => 'settings_gpls_woo_rfq_field_lic_page',

                    );

                } else {
                    $rfqtk_field_setting = array();
                }


                $settings =

                    array(
                        'general_lic_page_section_title' => array(
                            'name' => __('Manage RFQ-Toolkit License to recieve automatic product updates', 'rfqtk'),
                            'type' => 'title',
                            'desc' => '<h4></h4>',
                            'id' => 'general_lic_page_section_title'
                        ),

                        'settings_gpls_woo_rfq_lic_page' => $rfqtk_main_setting,

                        'settings_gpls_woo_rfq_upload_lic_page' => $rfqtk_upload_setting,

                        'settings_gpls_woo_rfq_field_lic_page' => $rfqtk_field_setting,

                        'settings_gpls_woo_rfq_pdf_lic_page' => $rfqtk_pdf_setting,

                        'general_lic_page_section_title_end' => array(
                            'type' => 'sectionend',
                            'id' => 'general_lic_page_section_title_end'
                        ),


                    );
                break;


        }

        return $settings;

    }


    /**
     * @param $sections
     * @return mixed
     */


}

