<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}


if (!class_exists('class_customer_confirmations_rfq_plus')) :

    /**
     * Customer Processing RFQ Email
     *
     * An email sent to the customer when a new RFQ is received.
     * @extends     WC_Email
     */
    class class_customer_confirmations_rfq_plus
    {

        /**
         * Constructor
         */
        function __construct()
        {
          add_action('plugins_loaded',array($this,'load_on_woo_commerce_loaded'),1000);
         $this->load_on_woo_commerce_loaded();

        }

        public function load_on_woo_commerce_loaded(){

            $show_products_before_stock = get_option('gpls_woo_rfq_customer_confirmation_products_before_stock', 'yes');
            $show_products_before_stock = 'yes';
            $products_priority = 200;

            $stock_priority =100;



            $send= get_option('gpls_woo_rfq_email_product_marketing_emails','no');

            if($send=="yes"){
                add_action('gpls_woo_rfq_after_normal_checkout', 'gpls_woo_rfq_plus_schedule_emails',$products_priority, 1);
            }


            $show_email_stock_message = get_option('gpls_woo_rfq_email_confirmation_stock_message', 'no');

            if ($show_email_stock_message == 'yes') {

                add_action('woocommerce_email_confirmation_messages', 'gpls_woo_rfq_plus_email_confirmation_stock_messages', $stock_priority, 3);


            }

            $show_email_product_message = get_option('gpls_woo_rfq_email_confirmation_product_messages', 'no');

            if ($show_email_product_message == 'yes')
            {

                add_action('woocommerce_email_confirmation_messages', 'gpls_woo_rfq_plus_email_confirmation_product_messages', $products_priority, 3);

            }

            $show_prices = get_option('settings_gpls_woo_rfq_show_prices_customer_confirmation_email', 'no');

            if ($show_prices == 'yes') {

                add_filter('gpls_woo_rfq_show_prices_customer_email', 'gpls_woo_rfq_plus_show_email_prices');

            }



            $include_all_metadata = get_option('gpls_woo_rfq_show_all_metadata_customer_confirmation_email', 'no');

            if ($include_all_metadata == 'yes') {

                add_filter('woocommerce_email_order_meta_fields', 'gpls_woo_rfq_plus_email_order_meta_fields', 10, 3);
            }




          //  add_action('woocommerce_email_order_meta', 'gpls_woo_rfq_plus_email_order_meta_display',200,4);

            if(!has_action('woocommerce_email_order_meta', 'gpls_woo_rfq_plus_customer_email_order_meta_display')) {
                add_action('woocommerce_email_order_meta', 'gpls_woo_rfq_plus_customer_email_order_meta_display', 201, 4);
            }

           // add_action( 'woocommerce_email_order_details','gplsrfq_customer_note_response_link',-1,4);

        }


    }

endif;


