<?php


if ( ! defined( 'ABSPATH' ) ) {
	exit;

}

if (!empty($cart_item['addons'])) {

    foreach ($cart_item['addons'] as $addon) {
        $key = $addon['name'];
        $price_type = $addon['price_type'];

        if (!$item || !is_callable(array($item, 'get_product'))) continue;

        $product = $item->get_product();

        $price='';
        $product_price=0;

        if ($product && is_callable(array($product, 'get_price'))) {

            $product_price = $product->get_price();

            $price = html_entity_decode(strip_tags(wc_price(rfqtk_prod_add_on_get_product_addon_price_for_display($addon['price'], $cart_item['data']))));

            if ($addon['price'] && 'percentage_based' === $price_type && 0 != $product_price) {
                $price = html_entity_decode(strip_tags(wc_price(rfqtk_prod_add_on_get_product_addon_price_for_display(($product_price * ($addon['price'] / 100))))));
            }
        }



        if ($addon['price'] && apply_filters('woocommerce_addons_add_price_to_name', true)) {
            $key .= '<span class="woocommerce-Price-amount" style="inline-block !important"> (' . $price . ')</span>';
        }

        if ('custom_price' === $addon['field_type']) {
            $addon['value'] = $addon['price'];
        }

        try {
            wc_add_order_item_meta($item_id, $key, $addon['value']);
        } catch (Exception $e) {
            error_log($e);
        }

    }
}

//TMXPO
$values = $cart_item;
try {
do_action('wc_epo_order_item_meta_before', $item, $cart_item_key, $values);

if (!empty($values['tmcartepo'])) {

    wc_add_order_item_meta($item_id, '_tmcartepo_data', $values['tmcartepo']);
    wc_add_order_item_meta($item_id, '_tm_epo_product_original_price', array($values['tm_epo_product_original_price']));
    wc_add_order_item_meta($item_id, '_tm_epo', array(1));
}
if (!empty($values['tmsubscriptionfee'])) {
    wc_add_order_item_meta($item_id, '_tmsubscriptionfee_data', array($values['tmsubscriptionfee']));
    wc_add_order_item_meta($item_id, __("Options Subscription fee", 'woocommerce-tm-extra-product-options'), $values['tmsubscriptionfee']);
}
if (!empty($values['tmcartfee'])) {
    wc_add_order_item_meta($item_id, '_tmcartfee_data', array($values['tmcartfee']));
}

do_action('wc_epo_order_item_meta', $item, $cart_item_key, $values);

} catch (Exception $e) {
}