<?php
/**
 * WOO-RFQ-List
 *
 * @author  Neah Plugins
 */

if (!defined('ABSPATH')) {
    exit;

}
if (is_admin()) {
    //  return;
}
error_reporting(0);

/**
 * @return array
 */



$gpls_woo_rfq_cart = gpls_woo_rfq_get_item('gpls_woo_rfq_cart');

if (is_array($gpls_woo_rfq_cart)) {
    $count = gpls_woo_rfq_get_rfq_cart_quantity();
} else {
    $count = 0;
}

$count = $count." ".__("items",'rfqtk');


if(isset( $args['before_widget']) && !empty( $args['before_widget'])) {
    echo $args['before_widget'];
}

echo $title . "&nbsp;&nbsp;".$count;

if(isset( $args['after_title']) && !empty( $args['after_title'])) {
    echo $args['after_title'];
}
//echo '&nbsp;'.$count;

echo '<div class="plus_widget_wrapper"><div class="quoteicon">&#x1f6d2;</div>';

list($nonce, $display, $gpls_woo_rfq_styles) = gpls_mini_page_extracted();

?>

<div  class="gpls_woo_rfq_request_mini_page" style="display: <?php echo $display; ?>">

    <?php do_action('woocommerce_before_rfq_mini_cart'); ?>

    <?php if ($gpls_woo_rfq_cart) : ?>

        <div style="clear: both; "></div>

        <?php do_action('woocommerce_before_mini_cart'); ?>

        <div  class="cart_list product_list_widget <?php echo esc_attr($args['list_class']); ?>">


            <?php do_action('woocommerce_before_rfq_mini_cart_contents'); ?>

            <?php
            foreach ($gpls_woo_rfq_cart as $cart_item_key => $cart_item) {

                $_product = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
                $product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);


                if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key)) {
                    //$_product = new WC_Product();
                    $product_name = apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key);
                    $thumbnail = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);
                    $product_price = apply_filters('woocommerce_cart_item_price', $_product->get_price() , $cart_item, $cart_item_key);
                    $times = '&times;';
                    if (get_option('settings_gpls_woo_rfq_normal_checkout_show_prices', 'no') == 'no') {
                        // echo 'individual_price_hidden $price = 0'.'<br />';
                        $product_price = ' ';
                        $times = '';
                    }


                    $product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);
                    ?>
                    <li class="<?php echo esc_attr(apply_filters('woocommerce_mini_cart_item_class', 'mini_cart_item', $cart_item, $cart_item_key)); ?>">
                        <?php

                        if (isset($cart_item['bundled_by']) && isset($cart_item['bundled_by'])) {
                            echo '';
                        } else {
                            $url = esc_url($wc_get_update_url) . "?remove_rfq_item=" . $cart_item_key;
                            echo apply_filters('woocommerce_cart_item_remove_link', sprintf(
                                '<a href="%s" style="float:left; display:inline-block;" type="submit" class="remove" title="%s" data-product_id="%s" data-product_sku="%s">' . $times . '</a>',
                                $url . '&man-deleted=' . $cart_item_key . "&gpls_woo_rfq_nonce=" . $nonce,
                                __('Remove this item', 'rfqtk'),
                                esc_attr($product_id),
                                esc_attr($_product->get_sku())
                            ), $cart_item_key);

                        }
                        ?>
                        <?php echo apply_filters('woocommerce_widget_cart_item_quantity', '<span style="float:left; display:inline-block; padding-left:5px;padding-right:5px" class="quantity">' . sprintf('%s ' . $times . ' %s', $cart_item['quantity'], $product_price) . '</span>', $cart_item, $cart_item_key); ?>
                        <?php if (!$_product->is_visible()) : ?>
                            <?php echo str_replace(array('http:', 'https:'), '', $thumbnail) . $product_name . '&nbsp;'; ?>
                        <?php else : ?>
                            <a style="float:left; display:inline-block;padding-right:2px" href="<?php echo esc_url($product_permalink); ?>">
                                <?php echo $product_name . '&nbsp;'; ?>
                            </a>
                            <a style="float:right; display:inline-block;padding-right:2px" href="<?php echo esc_url($product_permalink); ?>">
                                <?php echo str_replace(array('http:', 'https:'), '', $thumbnail) . '&nbsp;'; ?>
                            </a>
                        <?php endif; ?>
                        <?php //echo wc_get_formatted_cart_item_data( $cart_item ); ?>
                        <?php echo wc_get_formatted_cart_item_data($cart_item); ?>


                    </li>
                    <?php
                }
            }
            ?>

            <?php do_action('woocommerce_mini_cart_contents'); ?>


        </div>


        <?php
        $button_text = get_option('rfq_cart_wordings_submit_your_rfq_text', 'Submit Your Request For Quote');
        $button_text = __($button_text, 'rfqtk');

        $link_to_rfq_page = pls_woo_rfq_get_link_to_rfq();


        $view_your_cart_text = get_option('rfq_cart_wordings_view_rfq_cart_widget', __('View List', 'rfqtk'));
        $view_your_cart_text = __($view_your_cart_text, 'rfqtk');

        ?>
    <form action="<?php echo $link_to_rfq_page; ?>" method="get">
            <div class="rfq_proceed-to-checkout-min"
                 style="">

               <a  class="link_to_rfq_page_link_widget" href="<?php echo $link_to_rfq_page ?>"> <?php echo $view_your_cart_text;  ?></a>



            </div>
    </form>


    <?php else : ?>

        <li class="empty"><?php _e('No products in the quote list.', 'rfqtk'); ?></li>

    <?php endif; ?>

    <?php do_action('woocommerce_after_rfq_mini_cart'); ?>
</div>

<?php


$view_your_cart_title_text = get_option('rfq_cart_wordings_view_rfq_cart_widget_title', __('View Your Quote List', 'rfqtk'));
$view_your_cart_title_text = __($view_your_cart_title_text, 'rfqtk');

if(is_array($gpls_woo_rfq_cart)){
    $count=count($gpls_woo_rfq_cart);
}else{
    $count=0;
}

?>


<script>

    function plus_widget1(){
        jQuery(".rfq_page_plus_Widget").prop('title','<?php echo $view_your_cart_title_text ; ?>');
        jQuery(".rfq_page_plus_Widget .widget-title").html('<?php echo $title ; ?>');
        jQuery('.rfq_page_plus_Widget').css('cursor', 'pointer');

    }

    jQuery(window).on("load",function () {
        plus_widget1();
    });

    jQuery( document ).ajaxComplete(function() {
        plus_widget1();
    });

</script>
<?php
echo '</div>';
echo $args['after_widget'];

$ob_css=wc_get_template_html('woo-rfq/mini-rfq-cart-css.php', array(),
    '', gpls_woo_rfq_plus_DIR . 'woocommerce/');
echo $ob_css;

$ob_js=wc_get_template_html('woo-rfq/mini-rfq-cart-js.php', array(),
    '', gpls_woo_rfq_plus_DIR . 'woocommerce/');
echo $ob_js;
?>