<?php
namespace Aws\ElasticBeanstalk;

use Aws\AwsClient;

/**
 * This client is used to interact with the **AWS Elastic Beanstalk** service.
 *
 * @method \Aws\Result abortEnvironmentUpdate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise abortEnvironmentUpdateAsync(array $args = [])
 * @method \Aws\Result applyEnvironmentManagedAction(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise applyEnvironmentManagedActionAsync(array $args = [])
 * @method \Aws\Result associateEnvironmentOperationsRole(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise associateEnvironmentOperationsRoleAsync(array $args = [])
 * @method \Aws\Result checkDNSAvailability(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise checkDNSAvailabilityAsync(array $args = [])
 * @method \Aws\Result composeEnvironments(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise composeEnvironmentsAsync(array $args = [])
 * @method \Aws\Result createApplication(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createApplicationAsync(array $args = [])
 * @method \Aws\Result createApplicationVersion(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createApplicationVersionAsync(array $args = [])
 * @method \Aws\Result createConfigurationTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createConfigurationTemplateAsync(array $args = [])
 * @method \Aws\Result createEnvironment(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createEnvironmentAsync(array $args = [])
 * @method \Aws\Result createPlatformVersion(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createPlatformVersionAsync(array $args = [])
 * @method \Aws\Result createStorageLocation(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createStorageLocationAsync(array $args = [])
 * @method \Aws\Result deleteApplication(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteApplicationAsync(array $args = [])
 * @method \Aws\Result deleteApplicationVersion(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteApplicationVersionAsync(array $args = [])
 * @method \Aws\Result deleteConfigurationTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteConfigurationTemplateAsync(array $args = [])
 * @method \Aws\Result deleteEnvironmentConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteEnvironmentConfigurationAsync(array $args = [])
 * @method \Aws\Result deletePlatformVersion(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deletePlatformVersionAsync(array $args = [])
 * @method \Aws\Result describeAccountAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeAccountAttributesAsync(array $args = [])
 * @method \Aws\Result describeApplicationVersions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeApplicationVersionsAsync(array $args = [])
 * @method \Aws\Result describeApplications(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeApplicationsAsync(array $args = [])
 * @method \Aws\Result describeConfigurationOptions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeConfigurationOptionsAsync(array $args = [])
 * @method \Aws\Result describeConfigurationSettings(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeConfigurationSettingsAsync(array $args = [])
 * @method \Aws\Result describeEnvironmentHealth(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeEnvironmentHealthAsync(array $args = [])
 * @method \Aws\Result describeEnvironmentManagedActionHistory(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeEnvironmentManagedActionHistoryAsync(array $args = [])
 * @method \Aws\Result describeEnvironmentManagedActions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeEnvironmentManagedActionsAsync(array $args = [])
 * @method \Aws\Result describeEnvironmentResources(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeEnvironmentResourcesAsync(array $args = [])
 * @method \Aws\Result describeEnvironments(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeEnvironmentsAsync(array $args = [])
 * @method \Aws\Result describeEvents(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeEventsAsync(array $args = [])
 * @method \Aws\Result describeInstancesHealth(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeInstancesHealthAsync(array $args = [])
 * @method \Aws\Result describePlatformVersion(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describePlatformVersionAsync(array $args = [])
 * @method \Aws\Result disassociateEnvironmentOperationsRole(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise disassociateEnvironmentOperationsRoleAsync(array $args = [])
 * @method \Aws\Result listAvailableSolutionStacks(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listAvailableSolutionStacksAsync(array $args = [])
 * @method \Aws\Result listPlatformBranches(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listPlatformBranchesAsync(array $args = [])
 * @method \Aws\Result listPlatformVersions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listPlatformVersionsAsync(array $args = [])
 * @method \Aws\Result listTagsForResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listTagsForResourceAsync(array $args = [])
 * @method \Aws\Result rebuildEnvironment(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise rebuildEnvironmentAsync(array $args = [])
 * @method \Aws\Result requestEnvironmentInfo(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise requestEnvironmentInfoAsync(array $args = [])
 * @method \Aws\Result restartAppServer(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise restartAppServerAsync(array $args = [])
 * @method \Aws\Result retrieveEnvironmentInfo(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise retrieveEnvironmentInfoAsync(array $args = [])
 * @method \Aws\Result swapEnvironmentCNAMEs(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise swapEnvironmentCNAMEsAsync(array $args = [])
 * @method \Aws\Result terminateEnvironment(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise terminateEnvironmentAsync(array $args = [])
 * @method \Aws\Result updateApplication(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateApplicationAsync(array $args = [])
 * @method \Aws\Result updateApplicationResourceLifecycle(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateApplicationResourceLifecycleAsync(array $args = [])
 * @method \Aws\Result updateApplicationVersion(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateApplicationVersionAsync(array $args = [])
 * @method \Aws\Result updateConfigurationTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateConfigurationTemplateAsync(array $args = [])
 * @method \Aws\Result updateEnvironment(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateEnvironmentAsync(array $args = [])
 * @method \Aws\Result updateTagsForResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateTagsForResourceAsync(array $args = [])
 * @method \Aws\Result validateConfigurationSettings(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise validateConfigurationSettingsAsync(array $args = [])
 */
class ElasticBeanstalkClient extends AwsClient {}
