<?php
namespace Aws\GameLift;

use Aws\AwsClient;

/**
 * This client is used to interact with the **Amazon GameLift** service.
 *
 * @method \Aws\Result acceptMatch(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise acceptMatchAsync(array $args = [])
 * @method \Aws\Result claimGameServer(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise claimGameServerAsync(array $args = [])
 * @method \Aws\Result createAlias(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createAliasAsync(array $args = [])
 * @method \Aws\Result createBuild(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createBuildAsync(array $args = [])
 * @method \Aws\Result createFleet(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createFleetAsync(array $args = [])
 * @method \Aws\Result createFleetLocations(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createFleetLocationsAsync(array $args = [])
 * @method \Aws\Result createGameServerGroup(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createGameServerGroupAsync(array $args = [])
 * @method \Aws\Result createGameSession(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createGameSessionAsync(array $args = [])
 * @method \Aws\Result createGameSessionQueue(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createGameSessionQueueAsync(array $args = [])
 * @method \Aws\Result createMatchmakingConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createMatchmakingConfigurationAsync(array $args = [])
 * @method \Aws\Result createMatchmakingRuleSet(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createMatchmakingRuleSetAsync(array $args = [])
 * @method \Aws\Result createPlayerSession(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createPlayerSessionAsync(array $args = [])
 * @method \Aws\Result createPlayerSessions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createPlayerSessionsAsync(array $args = [])
 * @method \Aws\Result createScript(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createScriptAsync(array $args = [])
 * @method \Aws\Result createVpcPeeringAuthorization(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createVpcPeeringAuthorizationAsync(array $args = [])
 * @method \Aws\Result createVpcPeeringConnection(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createVpcPeeringConnectionAsync(array $args = [])
 * @method \Aws\Result deleteAlias(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteAliasAsync(array $args = [])
 * @method \Aws\Result deleteBuild(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteBuildAsync(array $args = [])
 * @method \Aws\Result deleteFleet(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteFleetAsync(array $args = [])
 * @method \Aws\Result deleteFleetLocations(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteFleetLocationsAsync(array $args = [])
 * @method \Aws\Result deleteGameServerGroup(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteGameServerGroupAsync(array $args = [])
 * @method \Aws\Result deleteGameSessionQueue(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteGameSessionQueueAsync(array $args = [])
 * @method \Aws\Result deleteMatchmakingConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteMatchmakingConfigurationAsync(array $args = [])
 * @method \Aws\Result deleteMatchmakingRuleSet(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteMatchmakingRuleSetAsync(array $args = [])
 * @method \Aws\Result deleteScalingPolicy(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteScalingPolicyAsync(array $args = [])
 * @method \Aws\Result deleteScript(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteScriptAsync(array $args = [])
 * @method \Aws\Result deleteVpcPeeringAuthorization(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteVpcPeeringAuthorizationAsync(array $args = [])
 * @method \Aws\Result deleteVpcPeeringConnection(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteVpcPeeringConnectionAsync(array $args = [])
 * @method \Aws\Result deregisterGameServer(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deregisterGameServerAsync(array $args = [])
 * @method \Aws\Result describeAlias(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeAliasAsync(array $args = [])
 * @method \Aws\Result describeBuild(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeBuildAsync(array $args = [])
 * @method \Aws\Result describeEC2InstanceLimits(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeEC2InstanceLimitsAsync(array $args = [])
 * @method \Aws\Result describeFleetAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeFleetAttributesAsync(array $args = [])
 * @method \Aws\Result describeFleetCapacity(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeFleetCapacityAsync(array $args = [])
 * @method \Aws\Result describeFleetEvents(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeFleetEventsAsync(array $args = [])
 * @method \Aws\Result describeFleetLocationAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeFleetLocationAttributesAsync(array $args = [])
 * @method \Aws\Result describeFleetLocationCapacity(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeFleetLocationCapacityAsync(array $args = [])
 * @method \Aws\Result describeFleetLocationUtilization(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeFleetLocationUtilizationAsync(array $args = [])
 * @method \Aws\Result describeFleetPortSettings(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeFleetPortSettingsAsync(array $args = [])
 * @method \Aws\Result describeFleetUtilization(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeFleetUtilizationAsync(array $args = [])
 * @method \Aws\Result describeGameServer(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeGameServerAsync(array $args = [])
 * @method \Aws\Result describeGameServerGroup(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeGameServerGroupAsync(array $args = [])
 * @method \Aws\Result describeGameServerInstances(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeGameServerInstancesAsync(array $args = [])
 * @method \Aws\Result describeGameSessionDetails(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeGameSessionDetailsAsync(array $args = [])
 * @method \Aws\Result describeGameSessionPlacement(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeGameSessionPlacementAsync(array $args = [])
 * @method \Aws\Result describeGameSessionQueues(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeGameSessionQueuesAsync(array $args = [])
 * @method \Aws\Result describeGameSessions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeGameSessionsAsync(array $args = [])
 * @method \Aws\Result describeInstances(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeInstancesAsync(array $args = [])
 * @method \Aws\Result describeMatchmaking(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeMatchmakingAsync(array $args = [])
 * @method \Aws\Result describeMatchmakingConfigurations(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeMatchmakingConfigurationsAsync(array $args = [])
 * @method \Aws\Result describeMatchmakingRuleSets(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeMatchmakingRuleSetsAsync(array $args = [])
 * @method \Aws\Result describePlayerSessions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describePlayerSessionsAsync(array $args = [])
 * @method \Aws\Result describeRuntimeConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeRuntimeConfigurationAsync(array $args = [])
 * @method \Aws\Result describeScalingPolicies(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeScalingPoliciesAsync(array $args = [])
 * @method \Aws\Result describeScript(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeScriptAsync(array $args = [])
 * @method \Aws\Result describeVpcPeeringAuthorizations(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeVpcPeeringAuthorizationsAsync(array $args = [])
 * @method \Aws\Result describeVpcPeeringConnections(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeVpcPeeringConnectionsAsync(array $args = [])
 * @method \Aws\Result getGameSessionLogUrl(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getGameSessionLogUrlAsync(array $args = [])
 * @method \Aws\Result getInstanceAccess(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getInstanceAccessAsync(array $args = [])
 * @method \Aws\Result listAliases(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listAliasesAsync(array $args = [])
 * @method \Aws\Result listBuilds(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listBuildsAsync(array $args = [])
 * @method \Aws\Result listFleets(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listFleetsAsync(array $args = [])
 * @method \Aws\Result listGameServerGroups(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listGameServerGroupsAsync(array $args = [])
 * @method \Aws\Result listGameServers(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listGameServersAsync(array $args = [])
 * @method \Aws\Result listScripts(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listScriptsAsync(array $args = [])
 * @method \Aws\Result listTagsForResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listTagsForResourceAsync(array $args = [])
 * @method \Aws\Result putScalingPolicy(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise putScalingPolicyAsync(array $args = [])
 * @method \Aws\Result registerGameServer(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise registerGameServerAsync(array $args = [])
 * @method \Aws\Result requestUploadCredentials(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise requestUploadCredentialsAsync(array $args = [])
 * @method \Aws\Result resolveAlias(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise resolveAliasAsync(array $args = [])
 * @method \Aws\Result resumeGameServerGroup(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise resumeGameServerGroupAsync(array $args = [])
 * @method \Aws\Result searchGameSessions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise searchGameSessionsAsync(array $args = [])
 * @method \Aws\Result startFleetActions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise startFleetActionsAsync(array $args = [])
 * @method \Aws\Result startGameSessionPlacement(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise startGameSessionPlacementAsync(array $args = [])
 * @method \Aws\Result startMatchBackfill(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise startMatchBackfillAsync(array $args = [])
 * @method \Aws\Result startMatchmaking(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise startMatchmakingAsync(array $args = [])
 * @method \Aws\Result stopFleetActions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise stopFleetActionsAsync(array $args = [])
 * @method \Aws\Result stopGameSessionPlacement(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise stopGameSessionPlacementAsync(array $args = [])
 * @method \Aws\Result stopMatchmaking(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise stopMatchmakingAsync(array $args = [])
 * @method \Aws\Result suspendGameServerGroup(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise suspendGameServerGroupAsync(array $args = [])
 * @method \Aws\Result tagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise tagResourceAsync(array $args = [])
 * @method \Aws\Result untagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise untagResourceAsync(array $args = [])
 * @method \Aws\Result updateAlias(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateAliasAsync(array $args = [])
 * @method \Aws\Result updateBuild(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateBuildAsync(array $args = [])
 * @method \Aws\Result updateFleetAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateFleetAttributesAsync(array $args = [])
 * @method \Aws\Result updateFleetCapacity(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateFleetCapacityAsync(array $args = [])
 * @method \Aws\Result updateFleetPortSettings(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateFleetPortSettingsAsync(array $args = [])
 * @method \Aws\Result updateGameServer(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateGameServerAsync(array $args = [])
 * @method \Aws\Result updateGameServerGroup(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateGameServerGroupAsync(array $args = [])
 * @method \Aws\Result updateGameSession(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateGameSessionAsync(array $args = [])
 * @method \Aws\Result updateGameSessionQueue(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateGameSessionQueueAsync(array $args = [])
 * @method \Aws\Result updateMatchmakingConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateMatchmakingConfigurationAsync(array $args = [])
 * @method \Aws\Result updateRuntimeConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateRuntimeConfigurationAsync(array $args = [])
 * @method \Aws\Result updateScript(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateScriptAsync(array $args = [])
 * @method \Aws\Result validateMatchmakingRuleSet(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise validateMatchmakingRuleSetAsync(array $args = [])
 */
class GameLiftClient extends AwsClient {}
