<?php
namespace Aws\Pinpoint;

use Aws\Api\ApiProvider;
use Aws\Api\DocModel;
use Aws\Api\Service;
use Aws\AwsClient;

/**
 * This client is used to interact with the **Amazon Pinpoint** service.
 * @method \Aws\Result createApp(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createAppAsync(array $args = [])
 * @method \Aws\Result createCampaign(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createCampaignAsync(array $args = [])
 * @method \Aws\Result createEmailTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createEmailTemplateAsync(array $args = [])
 * @method \Aws\Result createExportJob(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createExportJobAsync(array $args = [])
 * @method \Aws\Result createImportJob(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createImportJobAsync(array $args = [])
 * @method \Aws\Result createInAppTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createInAppTemplateAsync(array $args = [])
 * @method \Aws\Result createJourney(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createJourneyAsync(array $args = [])
 * @method \Aws\Result createPushTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createPushTemplateAsync(array $args = [])
 * @method \Aws\Result createRecommenderConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createRecommenderConfigurationAsync(array $args = [])
 * @method \Aws\Result createSegment(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createSegmentAsync(array $args = [])
 * @method \Aws\Result createSmsTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createSmsTemplateAsync(array $args = [])
 * @method \Aws\Result createVoiceTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createVoiceTemplateAsync(array $args = [])
 * @method \Aws\Result deleteAdmChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteAdmChannelAsync(array $args = [])
 * @method \Aws\Result deleteApnsChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteApnsChannelAsync(array $args = [])
 * @method \Aws\Result deleteApnsSandboxChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteApnsSandboxChannelAsync(array $args = [])
 * @method \Aws\Result deleteApnsVoipChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteApnsVoipChannelAsync(array $args = [])
 * @method \Aws\Result deleteApnsVoipSandboxChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteApnsVoipSandboxChannelAsync(array $args = [])
 * @method \Aws\Result deleteApp(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteAppAsync(array $args = [])
 * @method \Aws\Result deleteBaiduChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteBaiduChannelAsync(array $args = [])
 * @method \Aws\Result deleteCampaign(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteCampaignAsync(array $args = [])
 * @method \Aws\Result deleteEmailChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteEmailChannelAsync(array $args = [])
 * @method \Aws\Result deleteEmailTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteEmailTemplateAsync(array $args = [])
 * @method \Aws\Result deleteEndpoint(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteEndpointAsync(array $args = [])
 * @method \Aws\Result deleteEventStream(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteEventStreamAsync(array $args = [])
 * @method \Aws\Result deleteGcmChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteGcmChannelAsync(array $args = [])
 * @method \Aws\Result deleteInAppTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteInAppTemplateAsync(array $args = [])
 * @method \Aws\Result deleteJourney(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteJourneyAsync(array $args = [])
 * @method \Aws\Result deletePushTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deletePushTemplateAsync(array $args = [])
 * @method \Aws\Result deleteRecommenderConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteRecommenderConfigurationAsync(array $args = [])
 * @method \Aws\Result deleteSegment(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteSegmentAsync(array $args = [])
 * @method \Aws\Result deleteSmsChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteSmsChannelAsync(array $args = [])
 * @method \Aws\Result deleteSmsTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteSmsTemplateAsync(array $args = [])
 * @method \Aws\Result deleteUserEndpoints(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteUserEndpointsAsync(array $args = [])
 * @method \Aws\Result deleteVoiceChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteVoiceChannelAsync(array $args = [])
 * @method \Aws\Result deleteVoiceTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteVoiceTemplateAsync(array $args = [])
 * @method \Aws\Result getAdmChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getAdmChannelAsync(array $args = [])
 * @method \Aws\Result getApnsChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getApnsChannelAsync(array $args = [])
 * @method \Aws\Result getApnsSandboxChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getApnsSandboxChannelAsync(array $args = [])
 * @method \Aws\Result getApnsVoipChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getApnsVoipChannelAsync(array $args = [])
 * @method \Aws\Result getApnsVoipSandboxChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getApnsVoipSandboxChannelAsync(array $args = [])
 * @method \Aws\Result getApp(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getAppAsync(array $args = [])
 * @method \Aws\Result getApplicationDateRangeKpi(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getApplicationDateRangeKpiAsync(array $args = [])
 * @method \Aws\Result getApplicationSettings(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getApplicationSettingsAsync(array $args = [])
 * @method \Aws\Result getApps(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getAppsAsync(array $args = [])
 * @method \Aws\Result getBaiduChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getBaiduChannelAsync(array $args = [])
 * @method \Aws\Result getCampaign(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getCampaignAsync(array $args = [])
 * @method \Aws\Result getCampaignActivities(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getCampaignActivitiesAsync(array $args = [])
 * @method \Aws\Result getCampaignDateRangeKpi(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getCampaignDateRangeKpiAsync(array $args = [])
 * @method \Aws\Result getCampaignVersion(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getCampaignVersionAsync(array $args = [])
 * @method \Aws\Result getCampaignVersions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getCampaignVersionsAsync(array $args = [])
 * @method \Aws\Result getCampaigns(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getCampaignsAsync(array $args = [])
 * @method \Aws\Result getChannels(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getChannelsAsync(array $args = [])
 * @method \Aws\Result getEmailChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getEmailChannelAsync(array $args = [])
 * @method \Aws\Result getEmailTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getEmailTemplateAsync(array $args = [])
 * @method \Aws\Result getUserEndpoint(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getUserEndpointAsync(array $args = [])
 * @method \Aws\Result getEventStream(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getEventStreamAsync(array $args = [])
 * @method \Aws\Result getExportJob(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getExportJobAsync(array $args = [])
 * @method \Aws\Result getExportJobs(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getExportJobsAsync(array $args = [])
 * @method \Aws\Result getGcmChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getGcmChannelAsync(array $args = [])
 * @method \Aws\Result getImportJob(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getImportJobAsync(array $args = [])
 * @method \Aws\Result getImportJobs(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getImportJobsAsync(array $args = [])
 * @method \Aws\Result getInAppMessages(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getInAppMessagesAsync(array $args = [])
 * @method \Aws\Result getInAppTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getInAppTemplateAsync(array $args = [])
 * @method \Aws\Result getJourney(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getJourneyAsync(array $args = [])
 * @method \Aws\Result getJourneyDateRangeKpi(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getJourneyDateRangeKpiAsync(array $args = [])
 * @method \Aws\Result getJourneyExecutionActivityMetrics(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getJourneyExecutionActivityMetricsAsync(array $args = [])
 * @method \Aws\Result getJourneyExecutionMetrics(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getJourneyExecutionMetricsAsync(array $args = [])
 * @method \Aws\Result getPushTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getPushTemplateAsync(array $args = [])
 * @method \Aws\Result getRecommenderConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getRecommenderConfigurationAsync(array $args = [])
 * @method \Aws\Result getRecommenderConfigurations(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getRecommenderConfigurationsAsync(array $args = [])
 * @method \Aws\Result getSegment(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSegmentAsync(array $args = [])
 * @method \Aws\Result getSegmentExportJobs(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSegmentExportJobsAsync(array $args = [])
 * @method \Aws\Result getSegmentImportJobs(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSegmentImportJobsAsync(array $args = [])
 * @method \Aws\Result getSegmentVersion(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSegmentVersionAsync(array $args = [])
 * @method \Aws\Result getSegmentVersions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSegmentVersionsAsync(array $args = [])
 * @method \Aws\Result getSegments(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSegmentsAsync(array $args = [])
 * @method \Aws\Result getSmsChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSmsChannelAsync(array $args = [])
 * @method \Aws\Result getSmsTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSmsTemplateAsync(array $args = [])
 * @method \Aws\Result getUserEndpoints(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getUserEndpointsAsync(array $args = [])
 * @method \Aws\Result getVoiceChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getVoiceChannelAsync(array $args = [])
 * @method \Aws\Result getVoiceTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getVoiceTemplateAsync(array $args = [])
 * @method \Aws\Result listJourneys(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listJourneysAsync(array $args = [])
 * @method \Aws\Result listTagsForResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listTagsForResourceAsync(array $args = [])
 * @method \Aws\Result listTemplateVersions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listTemplateVersionsAsync(array $args = [])
 * @method \Aws\Result listTemplates(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listTemplatesAsync(array $args = [])
 * @method \Aws\Result phoneNumberValidate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise phoneNumberValidateAsync(array $args = [])
 * @method \Aws\Result putEventStream(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise putEventStreamAsync(array $args = [])
 * @method \Aws\Result putEvents(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise putEventsAsync(array $args = [])
 * @method \Aws\Result removeAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise removeAttributesAsync(array $args = [])
 * @method \Aws\Result sendMessages(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise sendMessagesAsync(array $args = [])
 * @method \Aws\Result sendOTPMessage(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise sendOTPMessageAsync(array $args = [])
 * @method \Aws\Result sendUsersMessages(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise sendUsersMessagesAsync(array $args = [])
 * @method \Aws\Result tagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise tagResourceAsync(array $args = [])
 * @method \Aws\Result untagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise untagResourceAsync(array $args = [])
 * @method \Aws\Result updateAdmChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateAdmChannelAsync(array $args = [])
 * @method \Aws\Result updateApnsChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateApnsChannelAsync(array $args = [])
 * @method \Aws\Result updateApnsSandboxChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateApnsSandboxChannelAsync(array $args = [])
 * @method \Aws\Result updateApnsVoipChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateApnsVoipChannelAsync(array $args = [])
 * @method \Aws\Result updateApnsVoipSandboxChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateApnsVoipSandboxChannelAsync(array $args = [])
 * @method \Aws\Result updateApplicationSettings(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateApplicationSettingsAsync(array $args = [])
 * @method \Aws\Result updateBaiduChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateBaiduChannelAsync(array $args = [])
 * @method \Aws\Result updateCampaign(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateCampaignAsync(array $args = [])
 * @method \Aws\Result updateEmailChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateEmailChannelAsync(array $args = [])
 * @method \Aws\Result updateEmailTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateEmailTemplateAsync(array $args = [])
 * @method \Aws\Result updateUserEndpoint(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateUserEndpointAsync(array $args = [])
 * @method \Aws\Result updateUserEndpointsBatch(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateUserEndpointsBatchAsync(array $args = [])
 * @method \Aws\Result updateGcmChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateGcmChannelAsync(array $args = [])
 * @method \Aws\Result updateInAppTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateInAppTemplateAsync(array $args = [])
 * @method \Aws\Result updateJourney(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateJourneyAsync(array $args = [])
 * @method \Aws\Result updateJourneyState(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateJourneyStateAsync(array $args = [])
 * @method \Aws\Result updatePushTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updatePushTemplateAsync(array $args = [])
 * @method \Aws\Result updateRecommenderConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateRecommenderConfigurationAsync(array $args = [])
 * @method \Aws\Result updateSegment(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateSegmentAsync(array $args = [])
 * @method \Aws\Result updateSmsChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateSmsChannelAsync(array $args = [])
 * @method \Aws\Result updateSmsTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateSmsTemplateAsync(array $args = [])
 * @method \Aws\Result updateTemplateActiveVersion(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateTemplateActiveVersionAsync(array $args = [])
 * @method \Aws\Result updateVoiceChannel(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateVoiceChannelAsync(array $args = [])
 * @method \Aws\Result updateVoiceTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateVoiceTemplateAsync(array $args = [])
 * @method \Aws\Result verifyOTPMessage(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise verifyOTPMessageAsync(array $args = [])
 */
class PinpointClient extends AwsClient {}