<?php
namespace Aws\Route53Domains;

use Aws\AwsClient;

/**
 * This client is used to interact with the **Amazon Route 53 Domains** service.
 *
 * @method \Aws\Result acceptDomainTransferFromAnotherAwsAccount(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise acceptDomainTransferFromAnotherAwsAccountAsync(array $args = [])
 * @method \Aws\Result cancelDomainTransferToAnotherAwsAccount(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise cancelDomainTransferToAnotherAwsAccountAsync(array $args = [])
 * @method \Aws\Result checkDomainAvailability(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise checkDomainAvailabilityAsync(array $args = [])
 * @method \Aws\Result checkDomainTransferability(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise checkDomainTransferabilityAsync(array $args = [])
 * @method \Aws\Result deleteDomain(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteDomainAsync(array $args = [])
 * @method \Aws\Result deleteTagsForDomain(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteTagsForDomainAsync(array $args = [])
 * @method \Aws\Result disableDomainAutoRenew(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise disableDomainAutoRenewAsync(array $args = [])
 * @method \Aws\Result disableDomainTransferLock(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise disableDomainTransferLockAsync(array $args = [])
 * @method \Aws\Result enableDomainAutoRenew(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise enableDomainAutoRenewAsync(array $args = [])
 * @method \Aws\Result enableDomainTransferLock(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise enableDomainTransferLockAsync(array $args = [])
 * @method \Aws\Result getContactReachabilityStatus(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getContactReachabilityStatusAsync(array $args = [])
 * @method \Aws\Result getDomainDetail(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getDomainDetailAsync(array $args = [])
 * @method \Aws\Result getDomainSuggestions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getDomainSuggestionsAsync(array $args = [])
 * @method \Aws\Result getOperationDetail(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getOperationDetailAsync(array $args = [])
 * @method \Aws\Result listDomains(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listDomainsAsync(array $args = [])
 * @method \Aws\Result listOperations(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listOperationsAsync(array $args = [])
 * @method \Aws\Result listPrices(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listPricesAsync(array $args = [])
 * @method \Aws\Result listTagsForDomain(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listTagsForDomainAsync(array $args = [])
 * @method \Aws\Result registerDomain(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise registerDomainAsync(array $args = [])
 * @method \Aws\Result rejectDomainTransferFromAnotherAwsAccount(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise rejectDomainTransferFromAnotherAwsAccountAsync(array $args = [])
 * @method \Aws\Result renewDomain(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise renewDomainAsync(array $args = [])
 * @method \Aws\Result resendContactReachabilityEmail(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise resendContactReachabilityEmailAsync(array $args = [])
 * @method \Aws\Result retrieveDomainAuthCode(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise retrieveDomainAuthCodeAsync(array $args = [])
 * @method \Aws\Result transferDomain(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise transferDomainAsync(array $args = [])
 * @method \Aws\Result transferDomainToAnotherAwsAccount(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise transferDomainToAnotherAwsAccountAsync(array $args = [])
 * @method \Aws\Result updateDomainContact(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateDomainContactAsync(array $args = [])
 * @method \Aws\Result updateDomainContactPrivacy(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateDomainContactPrivacyAsync(array $args = [])
 * @method \Aws\Result updateDomainNameservers(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateDomainNameserversAsync(array $args = [])
 * @method \Aws\Result updateTagsForDomain(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateTagsForDomainAsync(array $args = [])
 * @method \Aws\Result viewBilling(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise viewBillingAsync(array $args = [])
 */
class Route53DomainsClient extends AwsClient {}
